/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.AmexExpressCheckoutCard;
import com.braintreegateway.AndroidPayCard;
import com.braintreegateway.ApplePayCard;
import com.braintreegateway.CreditCard;
import com.braintreegateway.CustomActionsPaymentMethod;
import com.braintreegateway.MasterpassCard;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Result;
import com.braintreegateway.SamsungPayCard;
import com.braintreegateway.SepaDirectDebitAccount;
import com.braintreegateway.UnknownPaymentMethod;
import com.braintreegateway.UsBankAccount;
import com.braintreegateway.VenmoAccount;
import com.braintreegateway.VisaCheckoutCard;
import com.braintreegateway.util.NodeWrapper;

public class PaymentMethodParser {
    public static Result<? extends PaymentMethod> parsePaymentMethod(NodeWrapper node) {
        if (node.getElementName() == "amex-express-checkout-card") {
            return new Result<AmexExpressCheckoutCard>(node, AmexExpressCheckoutCard.class);
        }
        if (node.getElementName() == "android-pay-card") {
            return new Result<AndroidPayCard>(node, AndroidPayCard.class);
        }
        if (node.getElementName() == "apple-pay-card") {
            return new Result<ApplePayCard>(node, ApplePayCard.class);
        }
        if (node.getElementName() == "credit-card") {
            return new Result<CreditCard>(node, CreditCard.class);
        }
        if (node.getElementName() == "custom-actions-payment-method") {
            return new Result<CustomActionsPaymentMethod>(node, CustomActionsPaymentMethod.class);
        }
        if (node.getElementName() == "masterpass-card") {
            return new Result<MasterpassCard>(node, MasterpassCard.class);
        }
        if (node.getElementName() == "paypal-account") {
            return new Result<PayPalAccount>(node, PayPalAccount.class);
        }
        if (node.getElementName() == "samsung-pay-card") {
            return new Result<SamsungPayCard>(node, SamsungPayCard.class);
        }
        if (node.getElementName() == "sepa-debit-account") {
            return new Result<SepaDirectDebitAccount>(node, SepaDirectDebitAccount.class);
        }
        if (node.getElementName() == "us-bank-account") {
            return new Result<UsBankAccount>(node, UsBankAccount.class);
        }
        if (node.getElementName() == "venmo-account") {
            return new Result<VenmoAccount>(node, VenmoAccount.class);
        }
        if (node.getElementName() == "visa-checkout-card") {
            return new Result<VisaCheckoutCard>(node, VisaCheckoutCard.class);
        }
        return new Result<UnknownPaymentMethod>(node, UnknownPaymentMethod.class);
    }
}

