/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.BusinessDetails;
import com.braintreegateway.FundingDetails;
import com.braintreegateway.IndividualDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;

public class MerchantAccount {
    private final String id;
    private final Status status;
    private final MerchantAccount masterMerchantAccount;
    private final IndividualDetails individualDetails;
    private final BusinessDetails businessDetails;
    private final FundingDetails fundingDetails;
    private final String currencyIsoCode;
    private final Boolean isDefault;

    public MerchantAccount(NodeWrapper node) {
        NodeWrapper responseNode = node.findFirst("merchant-account");
        if (responseNode != null) {
            node = responseNode;
        }
        this.id = node.findString("id");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        this.isDefault = node.findBoolean("default");
        NodeWrapper masterNode = node.findFirst("master-merchant-account");
        this.masterMerchantAccount = masterNode != null ? new MerchantAccount(masterNode) : null;
        NodeWrapper individualNode = node.findFirst("individual");
        this.individualDetails = individualNode != null ? new IndividualDetails(individualNode) : null;
        NodeWrapper businessNode = node.findFirst("business");
        this.businessDetails = businessNode != null ? new BusinessDetails(businessNode) : null;
        NodeWrapper fundingNode = node.findFirst("funding");
        this.fundingDetails = fundingNode != null ? new FundingDetails(fundingNode) : null;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public MerchantAccount getMasterMerchantAccount() {
        return this.masterMerchantAccount;
    }

    public IndividualDetails getIndividualDetails() {
        return this.individualDetails;
    }

    public BusinessDetails getBusinessDetails() {
        return this.businessDetails;
    }

    public FundingDetails getFundingDetails() {
        return this.fundingDetails;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public boolean isSubMerchant() {
        return this.masterMerchantAccount != null;
    }

    public static enum FundingDestination {
        BANK("bank"),
        MOBILE_PHONE("mobile_phone"),
        EMAIL("email"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private FundingDestination(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Status {
        PENDING,
        ACTIVE,
        SUSPENDED,
        UNRECOGNIZED;

    }
}

