/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Dispute;
import com.braintreegateway.DisputeEvidence;
import com.braintreegateway.DisputePager;
import com.braintreegateway.DisputeSearchRequest;
import com.braintreegateway.FileEvidenceRequest;
import com.braintreegateway.PaginatedCollection;
import com.braintreegateway.PaginatedResult;
import com.braintreegateway.Result;
import com.braintreegateway.TextEvidenceRequest;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;

public class DisputeGateway {
    private Configuration configuration;
    private Http http;

    public DisputeGateway(Http http, Configuration configuration) {
        this.configuration = configuration;
        this.http = http;
    }

    public Result<Dispute> accept(String id) {
        try {
            if (id == null || id.trim().equals("")) {
                throw new NotFoundException();
            }
            NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/disputes/" + id + "/accept");
            if (response.getElementName().equals("api-error-response")) {
                return new Result<Dispute>(response, Dispute.class);
            }
            return new Result<Dispute>();
        }
        catch (NotFoundException e) {
            throw new NotFoundException("dispute with id \"" + id + "\" not found");
        }
    }

    public Result<DisputeEvidence> addFileEvidence(String disputeId, String documentId) {
        return this.addFileEvidence(disputeId, new FileEvidenceRequest().documentId(documentId));
    }

    public Result<DisputeEvidence> addFileEvidence(String disputeId, FileEvidenceRequest fileEvidenceRequest) {
        if (disputeId == null || disputeId.trim().equals("")) {
            throw new NotFoundException("dispute with id \"" + disputeId + "\" not found");
        }
        if (fileEvidenceRequest.getDocumentId() == null || fileEvidenceRequest.getDocumentId().trim().equals("")) {
            throw new NotFoundException("document with id \"" + fileEvidenceRequest.getDocumentId() + "\" not found");
        }
        try {
            NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/disputes/" + disputeId + "/evidence", fileEvidenceRequest);
            return new Result<DisputeEvidence>(response, DisputeEvidence.class);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("dispute with id \"" + disputeId + "\" not found");
        }
    }

    public Result<DisputeEvidence> addTextEvidence(String id, TextEvidenceRequest textEvidenceRequest) {
        if (textEvidenceRequest == null) {
            throw new IllegalArgumentException("TextEvidenceRequest cannot be null");
        }
        return this.addTextEvidenceRequest(id, textEvidenceRequest);
    }

    public Result<DisputeEvidence> addTextEvidence(String id, String content) {
        TextEvidenceRequest textEvidenceRequest = new TextEvidenceRequest().content(content);
        return this.addTextEvidenceRequest(id, textEvidenceRequest);
    }

    private Result<DisputeEvidence> addTextEvidenceRequest(String id, TextEvidenceRequest textEvidenceRequest) {
        String content = textEvidenceRequest.getContent();
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException("Dispute ID is required");
        }
        if (content == null || content.trim().equals("")) {
            throw new IllegalArgumentException("Content cannot be empty");
        }
        try {
            NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/disputes/" + id + "/evidence", textEvidenceRequest);
            return new Result<DisputeEvidence>(response, DisputeEvidence.class);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Dispute with ID \"" + id + "\" not found");
        }
    }

    public Result<Dispute> finalize(String id) {
        try {
            if (id == null || id.trim().equals("")) {
                throw new NotFoundException();
            }
            NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/disputes/" + id + "/finalize");
            if (response.getElementName().equals("api-error-response")) {
                return new Result<Dispute>(response, Dispute.class);
            }
            return new Result<Dispute>();
        }
        catch (NotFoundException e) {
            throw new NotFoundException("dispute with id \"" + id + "\" not found");
        }
    }

    public Dispute find(String id) {
        try {
            if (id == null || id.trim().equals("")) {
                throw new NotFoundException();
            }
            return new Dispute(this.http.get(this.configuration.getMerchantPath() + "/disputes/" + id));
        }
        catch (NotFoundException e) {
            throw new NotFoundException("dispute with id \"" + id + "\" not found");
        }
    }

    public Result<Dispute> removeEvidence(String disputeId, String evidenceId) {
        try {
            if (disputeId == null || disputeId.trim().equals("") || evidenceId == null || evidenceId.trim().equals("")) {
                throw new NotFoundException();
            }
            NodeWrapper response = this.http.delete(this.configuration.getMerchantPath() + "/disputes/" + disputeId + "/evidence/" + evidenceId);
            if (response != null && response.getElementName().equals("api-error-response")) {
                return new Result<Dispute>(response, Dispute.class);
            }
            return new Result<Dispute>();
        }
        catch (NotFoundException e) {
            throw new NotFoundException("evidence with id \"" + evidenceId + "\" for dispute with id \"" + disputeId + "\" not found");
        }
    }

    public PaginatedCollection<Dispute> search(DisputeSearchRequest query) {
        return new PaginatedCollection<Dispute>(new DisputePager(this, query));
    }

    PaginatedResult<Dispute> fetchDisputes(DisputeSearchRequest query, int page) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/disputes/advanced_search?page=" + page, query);
        ArrayList<Dispute> disputes = new ArrayList<Dispute>();
        for (NodeWrapper node : response.findAll("dispute")) {
            disputes.add(new Dispute(node));
        }
        return new PaginatedResult<Dispute>(response.findInteger("total-items"), response.findInteger("page-size"), disputes);
    }
}

