/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PayPalAccountRequest;
import com.braintreegateway.Result;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

public class PayPalAccountGateway {
    private Http http;
    private Configuration configuration;

    public PayPalAccountGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public PayPalAccount find(String token) {
        return new PayPalAccount(this.http.get(this.configuration.getMerchantPath() + "/payment_methods/paypal_account/" + token));
    }

    public Result<PayPalAccount> delete(String token) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/paypal_account/" + token);
        return new Result<PayPalAccount>();
    }

    public Result<PayPalAccount> update(String token, PayPalAccountRequest request) {
        NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/payment_methods/paypal_account/" + token, request);
        return new Result<PayPalAccount>(response, PayPalAccount.class);
    }
}

