/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ApplePayCard
implements PaymentMethod {
    private String imageUrl;
    private String token;
    private boolean isDefault;
    private String bin;
    private String cardType;
    private String paymentInstrumentName;
    private String sourceDescription;
    private String last4;
    private String expirationMonth;
    private String expirationYear;
    private boolean expired;
    private String customerId;
    private String cardholderName;
    private Calendar createdAt;
    private Calendar updatedAt;
    private List<Subscription> subscriptions;

    public ApplePayCard(NodeWrapper node) {
        this.token = node.findString("token");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.bin = node.findString("bin");
        this.cardType = node.findString("card-type");
        this.paymentInstrumentName = node.findString("payment-instrument-name");
        this.sourceDescription = node.findString("source-description");
        this.last4 = node.findString("last-4");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.expired = node.findBoolean("expired");
        this.customerId = node.findString("customer-id");
        this.cardholderName = node.findString("cardholder-name");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public String getBin() {
        return this.bin;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getPaymentInstrumentName() {
        return this.paymentInstrumentName;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public boolean getExpired() {
        return this.expired;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public String getLast4() {
        return this.last4;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }
}

