/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Result;
import com.braintreegateway.SettlementBatchSummary;
import com.braintreegateway.SettlementBatchSummaryRequest;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettlementBatchSummaryGateway {
    private Http http;
    private Configuration configuration;

    public SettlementBatchSummaryGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<SettlementBatchSummary> generate(Calendar settlementDate) {
        SettlementBatchSummaryRequest request = new SettlementBatchSummaryRequest();
        request.settlementDate(settlementDate);
        return this.doGenerate(request);
    }

    public Result<SettlementBatchSummary> generate(Calendar settlementDate, String groupByCustomField) {
        SettlementBatchSummaryRequest request = new SettlementBatchSummaryRequest();
        request.settlementDate(settlementDate);
        request.groupByCustomField(groupByCustomField);
        return this.doGenerate(request);
    }

    private Result<SettlementBatchSummary> doGenerate(SettlementBatchSummaryRequest request) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/settlement_batch_summary", request);
        return new Result<SettlementBatchSummary>(node, SettlementBatchSummary.class);
    }
}

