/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.CreditCard;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterpassCard
implements PaymentMethod {
    private Address billingAddress;
    private String bin;
    private String cardholderName;
    private String cardType;
    private Calendar createdAt;
    private String customerId;
    private String customerLocation;
    private String expirationMonth;
    private String expirationYear;
    private boolean isDefault;
    private boolean isVenmoSdk;
    private boolean isExpired;
    private String imageUrl;
    private String last4;
    private String commercial;
    private String debit;
    private String durbinRegulated;
    private String healthcare;
    private String payroll;
    private String prepaid;
    private String productId;
    private String countryOfIssuance;
    private String issuingBank;
    private String uniqueNumberIdentifier;
    private List<Subscription> subscriptions;
    private String token;
    private Calendar updatedAt;

    public MasterpassCard(NodeWrapper node) {
        this.token = node.findString("token");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.bin = node.findString("bin");
        this.cardType = node.findString("card-type");
        this.cardholderName = node.findString("cardholder-name");
        this.customerId = node.findString("customer-id");
        this.customerLocation = node.findString("customer-location");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.isExpired = node.findBoolean("expired");
        this.last4 = node.findString("last-4");
        this.commercial = node.findString("commercial");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.healthcare = node.findString("healthcare");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.productId = node.findString("product-id");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.issuingBank = node.findString("issuing-bank");
        this.uniqueNumberIdentifier = node.findString("unique-number-identifier");
        NodeWrapper billingAddressResponse = node.findFirst("billing-address");
        if (billingAddressResponse != null) {
            this.billingAddress = new Address(billingAddressResponse);
        }
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getBin() {
        return this.bin;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getCardType() {
        return this.cardType;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerLocation() {
        return this.customerLocation;
    }

    public String getExpirationDate() {
        return this.expirationMonth + "/" + this.expirationYear;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getMaskedNumber() {
        return this.getBin() + "******" + this.getLast4();
    }

    public CreditCard.Commercial getCommercial() {
        if (this.commercial.equals(CreditCard.Commercial.YES.toString())) {
            return CreditCard.Commercial.YES;
        }
        if (this.commercial.equals(CreditCard.Commercial.NO.toString())) {
            return CreditCard.Commercial.NO;
        }
        return CreditCard.Commercial.UNKNOWN;
    }

    public CreditCard.Debit getDebit() {
        if (this.debit.equals(CreditCard.Debit.YES.toString())) {
            return CreditCard.Debit.YES;
        }
        if (this.debit.equals(CreditCard.Debit.NO.toString())) {
            return CreditCard.Debit.NO;
        }
        return CreditCard.Debit.UNKNOWN;
    }

    public CreditCard.DurbinRegulated getDurbinRegulated() {
        if (this.durbinRegulated.equals(CreditCard.DurbinRegulated.YES.toString())) {
            return CreditCard.DurbinRegulated.YES;
        }
        if (this.durbinRegulated.equals(CreditCard.DurbinRegulated.NO.toString())) {
            return CreditCard.DurbinRegulated.NO;
        }
        return CreditCard.DurbinRegulated.UNKNOWN;
    }

    public CreditCard.Healthcare getHealthcare() {
        if (this.healthcare.equals(CreditCard.Healthcare.YES.toString())) {
            return CreditCard.Healthcare.YES;
        }
        if (this.healthcare.equals(CreditCard.Healthcare.NO.toString())) {
            return CreditCard.Healthcare.NO;
        }
        return CreditCard.Healthcare.UNKNOWN;
    }

    public CreditCard.Payroll getPayroll() {
        if (this.payroll.equals(CreditCard.Payroll.YES.toString())) {
            return CreditCard.Payroll.YES;
        }
        if (this.payroll.equals(CreditCard.Payroll.NO.toString())) {
            return CreditCard.Payroll.NO;
        }
        return CreditCard.Payroll.UNKNOWN;
    }

    public CreditCard.Prepaid getPrepaid() {
        if (this.prepaid.equals(CreditCard.Prepaid.YES.toString())) {
            return CreditCard.Prepaid.YES;
        }
        if (this.prepaid.equals(CreditCard.Prepaid.NO.toString())) {
            return CreditCard.Prepaid.NO;
        }
        return CreditCard.Prepaid.UNKNOWN;
    }

    public String getProductId() {
        if (this.productId.equals("")) {
            return "Unknown";
        }
        return this.productId;
    }

    public String getCountryOfIssuance() {
        if (this.countryOfIssuance.equals("")) {
            return "Unknown";
        }
        return this.countryOfIssuance;
    }

    public String getIssuingBank() {
        if (this.issuingBank.equals("")) {
            return "Unknown";
        }
        return this.issuingBank;
    }

    public String getUniqueNumberIdentifier() {
        return this.uniqueNumberIdentifier;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isVenmoSdk() {
        return this.isVenmoSdk;
    }

    public boolean isExpired() {
        return this.isExpired;
    }
}

