/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCardVerification;
import com.braintreegateway.Subscription;
import com.braintreegateway.Transaction;
import com.braintreegateway.UsBankAccountVerification;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.util.NodeWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result<T> {
    private UsBankAccountVerification usBankAccountVerification;
    private CreditCardVerification creditCardVerification;
    private Transaction transaction;
    private Subscription subscription;
    private ValidationErrors errors;
    private Map<String, String> parameters;
    private String message;
    private T target;

    public static <T> T newInstanceFromNode(Class<T> klass, NodeWrapper node) {
        ReflectiveOperationException cause = null;
        try {
            return klass.getConstructor(NodeWrapper.class).newInstance(node);
        }
        catch (InstantiationException e) {
            cause = e;
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e;
        }
        catch (NoSuchMethodException e) {
            cause = e;
        }
        throw new IllegalArgumentException("Unknown klass: " + klass, cause);
    }

    public Result() {
    }

    public Result(ValidationErrors errors) {
        this.errors = errors;
    }

    public Result(T target) {
        this.target = target;
    }

    public Result(NodeWrapper node, Class<T> klass) {
        if (node.isSuccess()) {
            this.target = Result.newInstanceFromNode(klass, node);
        } else {
            NodeWrapper subscriptionNode;
            NodeWrapper transactionNode;
            NodeWrapper verificationNode;
            this.errors = new ValidationErrors(node);
            NodeWrapper usBankAccountVerificationNode = node.findFirst("us-bank-account-verification");
            if (usBankAccountVerificationNode != null) {
                this.usBankAccountVerification = new UsBankAccountVerification(usBankAccountVerificationNode);
            }
            if ((verificationNode = node.findFirst("verification")) != null) {
                this.creditCardVerification = new CreditCardVerification(verificationNode);
            }
            if ((transactionNode = node.findFirst("transaction")) != null) {
                this.transaction = new Transaction(transactionNode);
            }
            if ((subscriptionNode = node.findFirst("subscription")) != null) {
                this.subscription = new Subscription(subscriptionNode);
            }
            this.parameters = node.findFirst("params").getFormParameters();
            this.message = node.findString("message");
        }
    }

    public UsBankAccountVerification getUsBankAccountVerification() {
        return this.usBankAccountVerification;
    }

    public CreditCardVerification getCreditCardVerification() {
        return this.creditCardVerification;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public ValidationErrors getErrors() {
        return this.errors;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public T getTarget() {
        return this.target;
    }

    public boolean isSuccess() {
        return this.errors == null;
    }

    public String getMessage() {
        return this.message;
    }
}

