/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

final class RequestBodyFromStream
extends RequestBody {
    private final InputStream inputStream;
    private final ProgressListener progressListener;
    private final MediaType mediaType;
    private final int contentLength;

    RequestBodyFromStream(InputStream inputStream, MediaType mediaType, ProgressListener progressListener) {
        this.inputStream = inputStream;
        this.progressListener = progressListener;
        this.mediaType = mediaType;
        try {
            this.contentLength = inputStream.available();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input stream for upload", e);
        }
    }

    public long contentLength() {
        return this.contentLength;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        byte[] buffer = new byte[8192];
        int n = this.inputStream.read(buffer);
        int totalWritten = 0;
        while (n != -1) {
            bufferedSink.write(buffer, 0, n);
            totalWritten += n;
            if (this.progressListener != null) {
                this.progressListener.onProgressChanged(totalWritten, this.contentLength());
            }
            n = this.inputStream.read(buffer);
        }
    }
}

