/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.internal.utils.CollectionUtils;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@BoxResourceType(value="webhook")
public class BoxWebHook
extends BoxResource {
    public static final URLTemplate WEBHOOKS_URL_TEMPLATE = new URLTemplate("webhooks");
    public static final URLTemplate WEBHOOK_URL_TEMPLATE = new URLTemplate("webhooks/%s");
    private static final String JSON_KEY_ID = "id";
    private static final String JSON_KEY_TARGET = "target";
    private static final String JSON_KEY_TARGET_TYPE = "type";
    private static final String JSON_KEY_TARGET_ID = "id";
    private static final String JSON_KEY_ADDRESS = "address";
    private static final String JSON_KEY_TRIGGERS = "triggers";
    private static final String JSON_KEY_CREATED_BY = "created_by";
    private static final String JSON_KEY_CREATED_AT = "created_at";
    private static final CollectionUtils.Mapper<String, Trigger> TRIGGER_TO_VALUE = Trigger::getValue;
    private static final CollectionUtils.Mapper<Trigger, JsonValue> JSON_VALUE_TO_TRIGGER = value -> Trigger.fromValue(value.asString());

    public BoxWebHook(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxResource target, URL address, Trigger ... triggers) {
        return BoxWebHook.create(target, address, new HashSet<Trigger>(Arrays.asList(triggers)));
    }

    public static Info create(BoxResource target, URL address, Set<Trigger> triggers) {
        BoxAPIConnection api = target.getAPI();
        String type = BoxResource.getResourceType(target.getClass());
        BoxWebHook.validateTriggers(type, triggers);
        JsonObject targetJSON = new JsonObject().add(JSON_KEY_TARGET_TYPE, type).add("id", target.getID());
        JsonObject requestJSON = new JsonObject().add(JSON_KEY_TARGET, (JsonValue)targetJSON).add(JSON_KEY_ADDRESS, address.toExternalForm()).add(JSON_KEY_TRIGGERS, (JsonValue)BoxWebHook.toJsonArray(CollectionUtils.map(triggers, TRIGGER_TO_VALUE)));
        URL url = WEBHOOKS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            BoxWebHook webHook;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxWebHook boxWebHook = webHook = new BoxWebHook(api, responseJSON.get("id").asString());
            boxWebHook.getClass();
            Info info = boxWebHook.new Info(responseJSON);
            return info;
        }
    }

    private static JsonArray toJsonArray(Collection<String> values) {
        JsonArray array = new JsonArray();
        for (String value : values) {
            array.add(value);
        }
        return array;
    }

    public static Iterable<Info> all(final BoxAPIConnection api) {
        return new BoxResourceIterable<Info>(api, WEBHOOKS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]), 64){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxWebHook webHook;
                BoxWebHook boxWebHook = webHook = new BoxWebHook(api, jsonObject.get("id").asString());
                boxWebHook.getClass();
                return boxWebHook.new Info(jsonObject);
            }
        };
    }

    public static Iterable<Info> all(final BoxAPIConnection api, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Info>(api, WEBHOOKS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]), 64){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxWebHook webHook;
                BoxWebHook boxWebHook = webHook = new BoxWebHook(api, jsonObject.get("id").asString());
                boxWebHook.getClass();
                return boxWebHook.new Info(jsonObject);
            }
        };
    }

    public static void validateTriggers(String targetType, Collection<Trigger> triggers) {
        for (Trigger trigger : triggers) {
            BoxWebHook.validateTrigger(targetType, trigger);
        }
    }

    private static void validateTrigger(String targetType, Trigger trigger) {
        for (String type : trigger.getTypes()) {
            if (!targetType.equals(type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Provided trigger '%s' is not supported on provided target '%s'.", trigger.name(), targetType));
    }

    public Info getInfo(String ... fields) {
        URL url = WEBHOOK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        if (fields.length > 0) {
            QueryStringBuilder builder = new QueryStringBuilder().appendParam("fields", fields);
            url = WEBHOOK_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            Info info = new Info(Json.parse((String)response.getJSON()).asObject());
            return info;
        }
    }

    public void updateInfo(Info info) {
        URL url = WEBHOOK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            info.update(jsonObject);
        }
    }

    public void delete() {
        URL url = WEBHOOK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public class Info
    extends BoxResource.Info {
        private Target target;
        private URL address;
        private Set<Trigger> triggers;
        private BoxUser.Info createdBy;
        private Date createdAt;

        public Info() {
            this.target = BoxWebHook.this.getInfo(new String[0]).getTarget();
        }

        public Info(String json) {
            this(Json.parse((String)json).asObject());
        }

        public Info(JsonObject jsonObject) {
            block11: {
                super(jsonObject);
                if (jsonObject.get(BoxWebHook.JSON_KEY_TARGET) != null) {
                    JsonObject targetObject = jsonObject.get(BoxWebHook.JSON_KEY_TARGET).asObject();
                    String targetType = targetObject.get(BoxWebHook.JSON_KEY_TARGET_TYPE).asString();
                    String targetId = targetObject.get("id").asString();
                    this.target = new Target(targetType, targetId);
                }
                if (jsonObject.get(BoxWebHook.JSON_KEY_TRIGGERS) != null) {
                    this.triggers = new HashSet(CollectionUtils.map(jsonObject.get(BoxWebHook.JSON_KEY_TRIGGERS).asArray().values(), JSON_VALUE_TO_TRIGGER));
                }
                if (jsonObject.get(BoxWebHook.JSON_KEY_ADDRESS) != null) {
                    try {
                        this.address = new URL(jsonObject.get(BoxWebHook.JSON_KEY_ADDRESS).asString());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (jsonObject.get(BoxWebHook.JSON_KEY_CREATED_BY) != null) {
                    JsonObject userJSON = jsonObject.get(BoxWebHook.JSON_KEY_CREATED_BY).asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        BoxUser boxUser = user = new BoxUser(BoxWebHook.this.getAPI(), userJSON.get("id").asString());
                        boxUser.getClass();
                        this.createdBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                }
                if (jsonObject.get(BoxWebHook.JSON_KEY_CREATED_AT) != null) {
                    try {
                        this.createdAt = BoxDateFormat.parse(jsonObject.get(BoxWebHook.JSON_KEY_CREATED_AT).asString());
                    }
                    catch (ParseException e) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                    }
                }
            }
        }

        @Override
        public BoxWebHook getResource() {
            return BoxWebHook.this;
        }

        public Target getTarget() {
            return this.target;
        }

        public URL getAddress() {
            return this.address;
        }

        public Info setAddress(URL address) {
            if (address == null) {
                throw new IllegalArgumentException("Address cannot be null");
            }
            if (this.address == null || !this.address.equals(address)) {
                this.address = address;
                this.addPendingChange(BoxWebHook.JSON_KEY_ADDRESS, address.toExternalForm());
            }
            return this;
        }

        public Set<Trigger> getTriggers() {
            return this.triggers;
        }

        public Info setTriggers(Trigger ... triggers) {
            return this.setTriggers(new HashSet<Trigger>(Arrays.asList(triggers)));
        }

        public Info setTriggers(Set<Trigger> triggers) {
            BoxWebHook.validateTriggers(this.target.getType(), triggers);
            JsonArray oldValue = this.triggers != null ? BoxWebHook.toJsonArray(CollectionUtils.map(this.triggers, TRIGGER_TO_VALUE)) : null;
            JsonArray newValue = BoxWebHook.toJsonArray(CollectionUtils.map(triggers, TRIGGER_TO_VALUE));
            if (!newValue.equals((Object)oldValue)) {
                this.triggers = Collections.unmodifiableSet(triggers);
                this.addPendingChange(BoxWebHook.JSON_KEY_TRIGGERS, newValue);
            }
            return this;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals(BoxWebHook.JSON_KEY_TARGET)) {
                    String targetType = value.asObject().get(BoxWebHook.JSON_KEY_TARGET_TYPE).asString();
                    String targetId = value.asObject().get("id").asString();
                    this.target = new Target(targetType, targetId);
                } else if (memberName.equals(BoxWebHook.JSON_KEY_TRIGGERS)) {
                    this.triggers = new HashSet(CollectionUtils.map(value.asArray().values(), JSON_VALUE_TO_TRIGGER));
                } else if (memberName.equals(BoxWebHook.JSON_KEY_ADDRESS)) {
                    this.address = new URL(value.asString());
                } else if (memberName.equals(BoxWebHook.JSON_KEY_CREATED_BY)) {
                    JsonObject userJSON = value.asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxWebHook.this.getAPI(), userID);
                        boxUser.getClass();
                        this.createdBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                } else if (memberName.equals(BoxWebHook.JSON_KEY_CREATED_AT)) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static class Target {
        private final String type;
        private final String id;

        public Target(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum Trigger {
        FOLDER_CREATED("FOLDER.CREATED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_COPIED("FOLDER.COPIED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_MOVED("FOLDER.MOVED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_DOWNLOADED("FOLDER.DOWNLOADED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_TRASHED("FOLDER.TRASHED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_RESTORED("FOLDER.RESTORED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_DELETED("FOLDER.DELETED", BoxResource.getResourceType(BoxFolder.class)),
        FOLDER_RENAMED("FOLDER.RENAMED", BoxResource.getResourceType(BoxFolder.class)),
        FILE_UPLOADED("FILE.UPLOADED", BoxResource.getResourceType(BoxFolder.class)),
        FILE_COPIED("FILE.COPIED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_MOVED("FILE.MOVED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_PREVIEWED("FILE.PREVIEWED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_DOWNLOADED("FILE.DOWNLOADED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_LOCKED("FILE.LOCKED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_UNLOCKED("FILE.UNLOCKED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_TRASHED("FILE.TRASHED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_RESTORED("FILE.RESTORED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_DELETED("FILE.DELETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        FILE_RENAMED("FILE.RENAMED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        COMMENT_CREATED("COMMENT.CREATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        COMMENT_UPDATED("COMMENT.UPDATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        COMMENT_DELETED("COMMENT.DELETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        TASK_ASSIGNMENT_CREATED("TASK_ASSIGNMENT.CREATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        TASK_ASSIGNMENT_UPDATED("TASK_ASSIGNMENT.UPDATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        METADATA_INSTANCE_CREATED("METADATA_INSTANCE.CREATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        METADATA_INSTANCE_UPDATED("METADATA_INSTANCE.UPDATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        METADATA_INSTANCE_DELETED("METADATA_INSTANCE.DELETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        WEBHOOK_DELETED("WEBHOOK.DELETED", new String[0]),
        COLLABORATION_CREATED("COLLABORATION.CREATED", BoxResource.getResourceType(BoxFolder.class)),
        COLLABORATION_ACCEPTED("COLLABORATION.ACCEPTED", BoxResource.getResourceType(BoxFolder.class)),
        COLLABORATION_REJECTED("COLLABORATION.REJECTED", BoxResource.getResourceType(BoxFolder.class)),
        COLLABORATION_REMOVED("COLLABORATION.REMOVED", BoxResource.getResourceType(BoxFolder.class)),
        COLLABORATION_UPDATED("COLLABORATION.UPDATED", BoxResource.getResourceType(BoxFolder.class)),
        SHARED_LINK_CRATED("SHARED_LINK.CREATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        SHARED_LINK_UPDATED("SHARED_LINK.UPDATED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        SHARED_LINK_DELETED("SHARED_LINK.DELETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        SIGN_REQUEST_COMPLETED("SIGN_REQUEST.COMPLETED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        SIGN_REQUEST_DECLINED("SIGN_REQUEST.DECLINED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class)),
        SIGN_REQUEST_EXPIRED("SIGN_REQUEST.EXPIRED", BoxResource.getResourceType(BoxFolder.class), BoxResource.getResourceType(BoxFile.class));

        private final String value;
        private final String[] types;

        private Trigger(String value, String ... types) {
            this.value = value;
            this.types = types;
        }

        public static Trigger fromValue(String value) {
            for (Trigger trigger : Trigger.values()) {
                if (!trigger.getValue().equals(value)) continue;
                return trigger;
            }
            throw new IllegalArgumentException("No Trigger for value: " + value);
        }

        public String getValue() {
            return this.value;
        }

        public String[] getTypes() {
            return this.types;
        }
    }
}

