/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIResponse;
import com.box.sdk.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class BinaryBodyUtils {
    private static final int BUFFER_SIZE = 8192;

    private BinaryBodyUtils() {
    }

    static void writeStream(BoxAPIResponse response, OutputStream output) {
        BinaryBodyUtils.writeStream(response, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeStream(BoxAPIResponse response, OutputStream output, ProgressListener listener) {
        try {
            InputStream input = listener != null ? response.getBody(listener) : response.getBody();
            BinaryBodyUtils.writeStreamTo(input, output);
        }
        finally {
            response.close();
        }
    }

    static void writeStreamTo(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[8192];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

