/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAIAgent;
import com.box.sdk.BoxAIAgentAskBasicText;
import com.box.sdk.BoxAIAgentAskLongText;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxResourceType;
import com.box.sdk.internal.utils.JsonUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;

@BoxResourceType(value="ai_agent_extract")
public class BoxAIAgentExtract
extends BoxAIAgent {
    public static final String TYPE = "ai_agent_extract";
    private BoxAIAgentAskBasicText basicText;
    private BoxAIAgentAskLongText longText;

    public BoxAIAgentExtract(BoxAIAgentAskBasicText basicText, BoxAIAgentAskLongText longText) {
        super(TYPE);
        this.basicText = basicText;
        this.longText = longText;
    }

    public BoxAIAgentExtract(JsonObject jsonObject) {
        super(jsonObject);
    }

    public BoxAIAgentAskBasicText getBasicText() {
        return this.basicText;
    }

    public void setBasicText(BoxAIAgentAskBasicText basicText) {
        this.basicText = basicText;
    }

    public BoxAIAgentAskLongText getLongText() {
        return this.longText;
    }

    public void setLongText(BoxAIAgentAskLongText longText) {
        this.longText = longText;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        super.parseJSONMember(member);
        String memberName = member.getName();
        JsonValue memberValue = member.getValue();
        try {
            switch (memberName) {
                case "basic_text": {
                    this.basicText = new BoxAIAgentAskBasicText(memberValue.asObject());
                    break;
                }
                case "long_text": {
                    this.longText = new BoxAIAgentAskLongText(memberValue.asObject());
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new BoxAPIException("Could not parse JSON response.", e);
        }
    }

    @Override
    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        JsonUtils.addIfNotNull(jsonObject, "type", this.getType());
        JsonUtils.addIfNotNull(jsonObject, "basic_text", this.basicText.getJSONObject());
        JsonUtils.addIfNotNull(jsonObject, "long_text", this.longText.getJSONObject());
        return jsonObject;
    }
}

