/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxCollection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.BoxUser;
import com.box.sdk.BoxWatermark;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.SharedLinkAPIConnection;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BoxItem
extends BoxResource {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "sha1", "name", "description", "size", "path_collection", "created_at", "modified_at", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "created_by", "modified_by", "owned_by", "shared_link", "parent", "item_status", "version_number", "comment_count", "permissions", "tags", "lock", "extension", "is_package", "folder_upload_email", "item_collection", "sync_state", "has_collaborations", "can_non_owners_invite", "file_version", "collections", "expires_at"};
    public static final URLTemplate SHARED_ITEM_URL_TEMPLATE = new URLTemplate("shared_items");
    public static final URLTemplate WATERMARK_URL_TEMPLATE = new URLTemplate("/watermark");

    public BoxItem(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info getSharedItem(BoxAPIConnection api, String sharedLink) {
        return BoxItem.getSharedItem(api, sharedLink, null);
    }

    public static Info getSharedItem(BoxAPIConnection api, String sharedLink, String password) {
        SharedLinkAPIConnection newAPI = new SharedLinkAPIConnection(api, sharedLink, password);
        URL url = SHARED_ITEM_URL_TEMPLATE.build(((BoxAPIConnection)newAPI).getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest((BoxAPIConnection)newAPI, url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject json = Json.parse((String)response.getJSON()).asObject();
            Info info = (Info)BoxResource.parseInfo(newAPI, json);
            return info;
        }
    }

    protected URL getItemURL() {
        return new URLTemplate("").build(this.getAPI().getBaseURL(), new Object[0]);
    }

    protected BoxWatermark getWatermark(URLTemplate itemUrl, String ... fields) {
        URL watermarkUrl = itemUrl.build(this.getAPI().getBaseURL(), this.getID());
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = WATERMARK_URL_TEMPLATE.buildWithQuery(watermarkUrl.toString(), builder.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            BoxWatermark boxWatermark = new BoxWatermark(response.getJSON());
            return boxWatermark;
        }
    }

    protected BoxWatermark applyWatermark(URLTemplate itemUrl, String imprint) {
        URL watermarkUrl = itemUrl.build(this.getAPI().getBaseURL(), this.getID());
        URL url = WATERMARK_URL_TEMPLATE.build(watermarkUrl.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject body = new JsonObject().add("watermark", (JsonValue)new JsonObject().add("imprint", imprint));
        request.setBody(body.toString());
        try (BoxJSONResponse response = request.send();){
            BoxWatermark boxWatermark = new BoxWatermark(response.getJSON());
            return boxWatermark;
        }
    }

    protected void removeWatermark(URLTemplate itemUrl) {
        URL watermarkUrl = itemUrl.build(this.getAPI().getBaseURL(), this.getID());
        URL url = WATERMARK_URL_TEMPLATE.build(watermarkUrl.toString(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public abstract Info copy(BoxFolder var1);

    public abstract Info copy(BoxFolder var1, String var2);

    public abstract Info move(BoxFolder var1);

    public abstract Info move(BoxFolder var1, String var2);

    public abstract Info getInfo(String ... var1);

    public abstract Info setCollections(BoxCollection ... var1);

    public abstract class Info
    extends BoxResource.Info {
        private String type;
        private String sequenceID;
        private String etag;
        private String name;
        private Date createdAt;
        private Date modifiedAt;
        private String description;
        private long size;
        private List<BoxFolder.Info> pathCollection;
        private BoxUser.Info createdBy;
        private BoxUser.Info modifiedBy;
        private Date trashedAt;
        private Date purgedAt;
        private Date contentCreatedAt;
        private Date contentModifiedAt;
        private BoxUser.Info ownedBy;
        private BoxSharedLink sharedLink;
        private List<String> tags;
        private BoxFolder.Info parent;
        private String itemStatus;
        private Date expiresAt;
        private Set<BoxCollection.Info> collections;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getType() {
            return this.type;
        }

        public String getEtag() {
            return this.etag;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.addPendingChange("name", name);
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
            this.addPendingChange("description", description);
        }

        public long getSize() {
            return this.size;
        }

        public List<BoxFolder.Info> getPathCollection() {
            return this.pathCollection;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public BoxUser.Info getModifiedBy() {
            return this.modifiedBy;
        }

        public Date getTrashedAt() {
            return this.trashedAt;
        }

        public Date getPurgedAt() {
            return this.purgedAt;
        }

        public Date getContentCreatedAt() {
            return this.contentCreatedAt;
        }

        public Date getContentModifiedAt() {
            return this.contentModifiedAt;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public BoxUser.Info getOwnedBy() {
            return this.ownedBy;
        }

        public BoxSharedLink getSharedLink() {
            return this.sharedLink;
        }

        public void setSharedLink(BoxSharedLink sharedLink) {
            this.removeChildObject("shared_link");
            this.sharedLink = sharedLink;
            this.addChildObject("shared_link", sharedLink);
        }

        public void removeSharedLink() {
            this.addChildObject("shared_link", null);
        }

        public String getSequenceID() {
            return this.sequenceID;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
            JsonArray tagsJSON = new JsonArray();
            for (String tag : tags) {
                tagsJSON.add(tag);
            }
            this.addPendingChange("tags", tagsJSON);
        }

        public BoxFolder.Info getParent() {
            return this.parent;
        }

        public String getItemStatus() {
            return this.itemStatus;
        }

        public Iterable<BoxCollection.Info> getCollections() {
            return this.collections;
        }

        public void setCollections(Iterable<BoxCollection> collections) {
            if (this.collections == null) {
                this.collections = new HashSet<BoxCollection.Info>();
            } else {
                this.collections.clear();
            }
            JsonArray jsonArray = new JsonArray();
            for (BoxCollection collection : collections) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add("id", collection.getID());
                jsonArray.add((JsonValue)jsonObject);
                this.collections.add(new BoxCollection.Info(collection));
            }
            this.addPendingChange("collections", jsonArray);
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                switch (memberName) {
                    case "sequence_id": {
                        this.sequenceID = value.asString();
                        break;
                    }
                    case "type": {
                        this.type = value.asString();
                        break;
                    }
                    case "etag": {
                        this.etag = value.asString();
                        break;
                    }
                    case "name": {
                        this.name = value.asString();
                        break;
                    }
                    case "created_at": {
                        this.createdAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "modified_at": {
                        this.modifiedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "description": {
                        this.description = value.asString();
                        break;
                    }
                    case "size": {
                        this.size = Double.valueOf(value.toString()).longValue();
                        break;
                    }
                    case "trashed_at": {
                        this.trashedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "purged_at": {
                        this.purgedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "content_created_at": {
                        this.contentCreatedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "content_modified_at": {
                        this.contentModifiedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "expires_at": {
                        this.expiresAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "path_collection": {
                        this.pathCollection = this.parsePathCollection(value.asObject());
                        break;
                    }
                    case "created_by": {
                        this.createdBy = this.parseUserInfo(value.asObject());
                        break;
                    }
                    case "modified_by": {
                        this.modifiedBy = this.parseUserInfo(value.asObject());
                        break;
                    }
                    case "owned_by": {
                        this.ownedBy = this.parseUserInfo(value.asObject());
                        break;
                    }
                    case "shared_link": {
                        if (this.sharedLink == null) {
                            this.setSharedLink(new BoxSharedLink(value.asObject()));
                            break;
                        }
                        this.sharedLink.update(value.asObject());
                        break;
                    }
                    case "tags": {
                        this.tags = this.parseTags(value.asArray());
                        break;
                    }
                    case "parent": {
                        JsonObject parentObject = value.asObject();
                        if (this.parent == null) {
                            BoxFolder parentFolder;
                            String id = parentObject.get("id").asString();
                            BoxFolder boxFolder = parentFolder = new BoxFolder(BoxItem.this.getAPI(), id);
                            boxFolder.getClass();
                            this.parent = new BoxFolder.Info(boxFolder, parentObject);
                            break;
                        }
                        this.parent.update(parentObject);
                        break;
                    }
                    case "item_status": {
                        this.itemStatus = value.asString();
                        break;
                    }
                    case "collections": {
                        if (this.collections == null) {
                            this.collections = new HashSet<BoxCollection.Info>();
                        } else {
                            this.collections.clear();
                        }
                        BoxAPIConnection api = BoxItem.this.getAPI();
                        JsonArray jsonArray = value.asArray();
                        for (JsonValue arrayValue : jsonArray) {
                            BoxCollection collection;
                            JsonObject jsonObject = arrayValue.asObject();
                            String id = jsonObject.get("id").asString();
                            BoxCollection boxCollection = collection = new BoxCollection(api, id);
                            boxCollection.getClass();
                            BoxCollection.Info collectionInfo = new BoxCollection.Info(boxCollection, jsonObject);
                            this.collections.add(collectionInfo);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private List<BoxFolder.Info> parsePathCollection(JsonObject jsonObject) {
            int count = jsonObject.get("total_count").asInt();
            ArrayList<BoxFolder.Info> pathCollection = new ArrayList<BoxFolder.Info>(count);
            JsonArray entries = jsonObject.get("entries").asArray();
            for (JsonValue value : entries) {
                BoxFolder folder;
                JsonObject entry = value.asObject();
                String id = entry.get("id").asString();
                BoxFolder boxFolder = folder = new BoxFolder(BoxItem.this.getAPI(), id);
                boxFolder.getClass();
                pathCollection.add(new BoxFolder.Info(boxFolder, entry));
            }
            return pathCollection;
        }

        private BoxUser.Info parseUserInfo(JsonObject jsonObject) {
            BoxUser user;
            String userID = jsonObject.get("id").asString();
            BoxUser boxUser = user = new BoxUser(BoxItem.this.getAPI(), userID);
            boxUser.getClass();
            return new BoxUser.Info(boxUser, jsonObject);
        }

        private List<String> parseTags(JsonArray jsonArray) {
            ArrayList<String> tags = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                tags.add(value.asString());
            }
            return tags;
        }
    }
}

