/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSignRequestCreateParams;
import com.box.sdk.BoxSignRequestFile;
import com.box.sdk.BoxSignRequestPrefillTag;
import com.box.sdk.BoxSignRequestSignatureColor;
import com.box.sdk.BoxSignRequestSigner;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="sign_request")
public class BoxSignRequest
extends BoxResource {
    public static final URLTemplate SIGN_REQUESTS_URL_TEMPLATE = new URLTemplate("sign_requests");
    public static final URLTemplate SIGN_REQUEST_URL_TEMPLATE = new URLTemplate("sign_requests/%s");
    public static final URLTemplate SIGN_REQUEST_CANCEL_URL_TEMPLATE = new URLTemplate("sign_requests/%s/cancel");
    public static final URLTemplate SIGN_REQUEST_RESEND_URL_TEMPLATE = new URLTemplate("sign_requests/%s/resend");
    private static final int DEFAULT_LIMIT = 100;

    public BoxSignRequest(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createSignRequestFromFiles(BoxAPIConnection api, List<BoxFile.Info> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId, BoxSignRequestCreateParams optionalParams) {
        return BoxSignRequest.createSignRequest(api, BoxSignRequest.toBoxSignRequestFiles(sourceFiles), signers, parentFolderId, optionalParams);
    }

    public static Info createSignRequestFromFiles(BoxAPIConnection api, List<BoxFile.Info> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId) {
        return BoxSignRequest.createSignRequest(api, BoxSignRequest.toBoxSignRequestFiles(sourceFiles), signers, parentFolderId, null);
    }

    public static Info createSignRequest(BoxAPIConnection api, List<BoxSignRequestFile> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId) {
        return BoxSignRequest.createSignRequest(api, sourceFiles, signers, parentFolderId, null);
    }

    public static Info createSignRequest(BoxAPIConnection api, List<BoxSignRequestFile> sourceFiles, List<BoxSignRequestSigner> signers, String parentFolderId, BoxSignRequestCreateParams optionalParams) {
        BoxSignRequest signRequest;
        JsonObject requestJSON = new JsonObject();
        JsonArray sourceFilesJSON = new JsonArray();
        for (BoxSignRequestFile boxSignRequestFile : sourceFiles) {
            sourceFilesJSON.add((JsonValue)boxSignRequestFile.getJSONObject());
        }
        requestJSON.add("source_files", (JsonValue)sourceFilesJSON);
        JsonArray signersJSON = new JsonArray();
        for (BoxSignRequestSigner signer : signers) {
            signersJSON.add((JsonValue)signer.getJSONObject());
        }
        requestJSON.add("signers", (JsonValue)signersJSON);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("id", parentFolderId);
        jsonObject.add("type", "folder");
        requestJSON.add("parent_folder", (JsonValue)jsonObject);
        if (optionalParams != null) {
            optionalParams.appendParamsAsJson(requestJSON);
        }
        URL url = SIGN_REQUESTS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        BoxSignRequest boxSignRequest = signRequest = new BoxSignRequest(api, responseJSON.get("id").asString());
        boxSignRequest.getClass();
        return boxSignRequest.new Info(responseJSON);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxSignRequest.getAll(api, 100, fields);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = SIGN_REQUESTS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxSignRequest signRequest;
                BoxSignRequest boxSignRequest = signRequest = new BoxSignRequest(api, jsonObject.get("id").asString());
                boxSignRequest.getClass();
                return boxSignRequest.new Info(jsonObject);
            }
        };
    }

    private static List<BoxSignRequestFile> toBoxSignRequestFiles(List<BoxFile.Info> sourceFiles) {
        ArrayList<BoxSignRequestFile> files = new ArrayList<BoxSignRequestFile>();
        for (BoxFile.Info sourceFile : sourceFiles) {
            BoxSignRequestFile file = BoxSignRequestFile.fromFile(sourceFile);
            files.add(file);
        }
        return files;
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = SIGN_REQUEST_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        return new Info(responseJSON);
    }

    public Info cancel() {
        URL url = SIGN_REQUEST_CANCEL_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), "", this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        return new Info(responseJSON);
    }

    public void resend() {
        URL url = SIGN_REQUEST_RESEND_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), "", this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private boolean isDocumentPreparationNeeded;
        private boolean areTextSignaturesEnabled;
        private boolean areDatesEnabled;
        private BoxSignRequestSignatureColor signatureColor;
        private String emailSubject;
        private String emailMessage;
        private boolean areRemindersEnabled;
        private List<BoxFile.Info> sourceFiles;
        private BoxFolder.Info parentFolder;
        private List<BoxSignRequestSigner> signers;
        private String name;
        private List<BoxSignRequestPrefillTag> prefillTags;
        private Integer daysValid;
        private String externalId;
        private String prepareUrl;
        private BoxFile.Info signingLog;
        private BoxSignRequestStatus status;
        private BoxSignRequestSignFiles signFiles;
        private Date autoExpireAt;

        public Info() {
            super(BoxSignRequest.this);
        }

        public Info(String json) {
            super((BoxResource)BoxSignRequest.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxSignRequest.this, jsonObject);
        }

        public boolean getIsDocumentPreparationNeeded() {
            return this.isDocumentPreparationNeeded;
        }

        public boolean getAreTextSignaturesEnabled() {
            return this.areTextSignaturesEnabled;
        }

        public boolean getAreDatesEnabled() {
            return this.areDatesEnabled;
        }

        public BoxSignRequestSignatureColor getSignatureColor() {
            return this.signatureColor;
        }

        public String getEmailSubject() {
            return this.emailSubject;
        }

        public String getEmailMessage() {
            return this.emailMessage;
        }

        public boolean getAreRemindersEnabled() {
            return this.areRemindersEnabled;
        }

        public List<BoxFile.Info> getSourceFiles() {
            return this.sourceFiles;
        }

        public BoxFolder.Info getParentFolder() {
            return this.parentFolder;
        }

        public List<BoxSignRequestSigner> getSigners() {
            return this.signers;
        }

        public String getName() {
            return this.name;
        }

        public List<BoxSignRequestPrefillTag> getPrefillTags() {
            return this.prefillTags;
        }

        public Integer getDaysValid() {
            return this.daysValid;
        }

        public String getExternalId() {
            return this.externalId;
        }

        public String getPrepareUrl() {
            return this.prepareUrl;
        }

        public BoxFile.Info getSigningLog() {
            return this.signingLog;
        }

        public BoxSignRequestStatus getStatus() {
            return this.status;
        }

        public BoxSignRequestSignFiles getSignFiles() {
            return this.signFiles;
        }

        public Date getAutoExpireAt() {
            return this.autoExpireAt;
        }

        @Override
        public BoxSignRequest getResource() {
            return BoxSignRequest.this;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if ("is_document_preparation_needed".equals(memberName)) {
                    this.isDocumentPreparationNeeded = value.asBoolean();
                } else if ("are_text_signatures_enabled".equals(memberName)) {
                    this.areTextSignaturesEnabled = value.asBoolean();
                } else if ("are_dates_enabled".equals(memberName)) {
                    this.areDatesEnabled = value.asBoolean();
                } else if ("signature_color".equals(memberName)) {
                    this.signatureColor = BoxSignRequestSignatureColor.fromJSONString(value.asString());
                } else if ("email_subject".equals(memberName)) {
                    this.emailSubject = value.asString();
                } else if ("email_message".equals(memberName)) {
                    this.emailMessage = value.asString();
                } else if ("are_reminders_enabled".equals(memberName)) {
                    this.areRemindersEnabled = value.asBoolean();
                } else if ("signers".equals(memberName)) {
                    ArrayList<BoxSignRequestSigner> signers = new ArrayList<BoxSignRequestSigner>();
                    for (JsonValue signerJSON : value.asArray()) {
                        BoxSignRequestSigner signer = new BoxSignRequestSigner(signerJSON.asObject(), BoxSignRequest.this.getAPI());
                        signers.add(signer);
                    }
                    this.signers = signers;
                } else if ("source_files".equals(memberName)) {
                    this.sourceFiles = this.getFiles((JsonValue)value.asArray());
                } else if ("parent_folder".equals(memberName)) {
                    BoxFolder folder;
                    JsonObject folderJSON = value.asObject();
                    String folderID = folderJSON.get("id").asString();
                    BoxFolder boxFolder = folder = new BoxFolder(BoxSignRequest.this.getAPI(), folderID);
                    boxFolder.getClass();
                    this.parentFolder = new BoxFolder.Info(boxFolder, folderJSON);
                } else if ("name".equals(memberName)) {
                    this.name = value.asString();
                } else if ("prefill_tags".equals(memberName)) {
                    ArrayList<BoxSignRequestPrefillTag> prefillTags = new ArrayList<BoxSignRequestPrefillTag>();
                    for (JsonValue prefillTagJSON : value.asArray()) {
                        BoxSignRequestPrefillTag prefillTag = new BoxSignRequestPrefillTag(prefillTagJSON.asObject());
                        prefillTags.add(prefillTag);
                    }
                    this.prefillTags = prefillTags;
                } else if ("days_valid".equals(memberName)) {
                    this.daysValid = value.asInt();
                } else if ("external_id".equals(memberName)) {
                    this.externalId = value.asString();
                } else if ("prepare_url".equals(memberName)) {
                    this.prepareUrl = value.asString();
                } else if ("signing_log".equals(memberName)) {
                    BoxFile file;
                    JsonObject signingLogJSON = value.asObject();
                    String fileID = signingLogJSON.get("id").asString();
                    BoxFile boxFile = file = new BoxFile(BoxSignRequest.this.getAPI(), fileID);
                    boxFile.getClass();
                    this.signingLog = new BoxFile.Info(boxFile, signingLogJSON);
                } else if ("status".equals(memberName)) {
                    this.status = BoxSignRequestStatus.fromJSONString(value.asString());
                } else if ("sign_files".equals(memberName)) {
                    JsonObject signFilesJSON = value.asObject();
                    JsonValue filesArray = signFilesJSON.get("files");
                    List<BoxFile.Info> signFiles = this.getFiles(filesArray);
                    boolean isReadyForDownload = signFilesJSON.get("is_ready_for_download").asBoolean();
                    this.signFiles = new BoxSignRequestSignFiles(signFiles, isReadyForDownload);
                } else if ("auto_expire_at".equals(memberName)) {
                    this.autoExpireAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private List<BoxFile.Info> getFiles(JsonValue filesArray) {
            ArrayList<BoxFile.Info> files = new ArrayList<BoxFile.Info>();
            for (JsonValue fileJSON : filesArray.asArray()) {
                BoxFile file;
                String fileID = fileJSON.asObject().get("id").asString();
                BoxFile boxFile = file = new BoxFile(BoxSignRequest.this.getAPI(), fileID);
                boxFile.getClass();
                files.add(new BoxFile.Info(boxFile, fileJSON.asObject()));
            }
            return files;
        }

        public class BoxSignRequestSignFiles {
            private List<BoxFile.Info> files;
            private boolean isReadyToDownload;

            public BoxSignRequestSignFiles(List<BoxFile.Info> files, boolean isReadyToDownload) {
                this.files = files;
                this.isReadyToDownload = isReadyToDownload;
            }

            public List<BoxFile.Info> getFiles() {
                return this.files;
            }

            public boolean getIsReadyToDownload() {
                return this.isReadyToDownload;
            }
        }
    }

    public static enum BoxSignRequestStatus {
        Converting("converting"),
        Created("created"),
        Sent("sent"),
        Viewed("viewed"),
        Signed("signed"),
        Cancelled("cancelled"),
        Declined("declined"),
        ErrorConverting("error_converting"),
        ErrorSending("error_sending"),
        Expired("expired");

        private final String jsonValue;

        private BoxSignRequestStatus(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestStatus fromJSONString(String jsonValue) {
            if ("converting".equals(jsonValue)) {
                return Converting;
            }
            if ("created".equals(jsonValue)) {
                return Created;
            }
            if ("sent".equals(jsonValue)) {
                return Sent;
            }
            if ("viewed".equals(jsonValue)) {
                return Viewed;
            }
            if ("signed".equals(jsonValue)) {
                return Signed;
            }
            if ("cancelled".equals(jsonValue)) {
                return Cancelled;
            }
            if ("declined".equals(jsonValue)) {
                return Declined;
            }
            if ("error_converting".equals(jsonValue)) {
                return ErrorConverting;
            }
            if ("error_sending".equals(jsonValue)) {
                return ErrorSending;
            }
            if ("expired".equals(jsonValue)) {
                return Expired;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid BoxSignRequestStatus value.");
        }
    }
}

