/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="file_request")
public class BoxFileRequest
extends BoxResource {
    public static final URLTemplate FILE_REQUEST_URL_TEMPLATE = new URLTemplate("file_requests/%s");
    public static final URLTemplate COPY_FILE_REQUEST_URL_TEMPLATE = new URLTemplate("file_requests/%s/copy");

    public BoxFileRequest(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public Info getInfo() {
        URL url = FILE_REQUEST_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON, this.getAPI().getBaseAppUrl());
    }

    public Info copyInfo(String folderId) {
        URL url = COPY_FILE_REQUEST_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject body = new JsonObject();
        JsonObject folderBody = new JsonObject();
        folderBody.add("id", folderId);
        folderBody.add("type", "folder");
        body.add("folder", (JsonValue)folderBody);
        request.setBody(body.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonObject, this.getAPI().getBaseAppUrl());
    }

    public Info copyInfo(Info info, String folderId) {
        URL url = COPY_FILE_REQUEST_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject body = new JsonObject();
        JsonObject pendingChanges = info.getPendingChangesAsJsonObject();
        if (pendingChanges != null) {
            body = pendingChanges;
        }
        JsonObject folderBody = new JsonObject();
        folderBody.add("id", folderId);
        folderBody.add("type", "folder");
        body.add("folder", (JsonValue)folderBody);
        request.setBody(body.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
        return new Info(jsonObject, this.getAPI().getBaseAppUrl());
    }

    public Info updateInfo(Info info) {
        URL url = FILE_REQUEST_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
        return info;
    }

    public void delete() {
        URL url = FILE_REQUEST_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private String type;
        private Date createdAt;
        private BoxUser.Info createdBy;
        private String description;
        private String etag;
        private Date expiresAt;
        private BoxFolder.Info folder;
        private boolean isDescriptionRequired;
        private boolean isEmailRequired;
        private Status status;
        private String title;
        private Date updatedAt;
        private BoxUser.Info updatedBy;
        private URL url;
        private String path;
        private String baseUrl;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject, String fileRequestBaseUrl) {
            super(jsonObject);
            try {
                this.baseUrl = fileRequestBaseUrl;
                this.url = new URL(this.baseUrl + this.path);
            }
            catch (MalformedURLException e) {
                throw new BoxAPIException("Couldn't construct url for file request", e);
            }
        }

        @Override
        public BoxFileRequest getResource() {
            return BoxFileRequest.this;
        }

        public String getType() {
            return this.type;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
            this.addPendingChange("description", description);
        }

        public String getEtag() {
            return this.etag;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
            this.addPendingChange("expires_at", BoxDateFormat.format(expiresAt));
        }

        public BoxFolder.Info getFolder() {
            return this.folder;
        }

        public Boolean getIsDescriptionRequired() {
            return this.isDescriptionRequired;
        }

        public void setIsDescriptionRequired(Boolean isDescriptionRequired) {
            this.isDescriptionRequired = isDescriptionRequired;
            this.addPendingChange("is_description_required", isDescriptionRequired);
        }

        public Boolean getIsEmailRequired() {
            return this.isEmailRequired;
        }

        public void setIsEmailRequired(Boolean isEmailRequired) {
            this.isEmailRequired = isEmailRequired;
            this.addPendingChange("is_email_required", isEmailRequired);
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
            this.addPendingChange("status", status.toJSONString());
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
            this.addPendingChange("title", title);
        }

        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        public BoxUser.Info getUpdatedBy() {
            return this.updatedBy;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) throws MalformedURLException {
            this.baseUrl = baseUrl;
            this.url = new URL(this.baseUrl + this.path);
        }

        public String getPath() {
            return this.path;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("type")) {
                    this.type = value.asString();
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("created_by")) {
                    BoxUser user;
                    JsonObject userJSON = value.asObject();
                    String userID = userJSON.get("id").asString();
                    BoxUser boxUser = user = new BoxUser(BoxFileRequest.this.getAPI(), userID);
                    boxUser.getClass();
                    this.createdBy = boxUser.new BoxUser.Info(userJSON);
                } else if (memberName.equals("description")) {
                    this.description = value.asString();
                } else if (memberName.equals("etag")) {
                    this.etag = value.asString();
                } else if (memberName.equals("expires_at")) {
                    this.expiresAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("folder")) {
                    BoxFolder folder;
                    JsonObject folderJSON = value.asObject();
                    String folderID = folderJSON.get("id").asString();
                    BoxFolder boxFolder = folder = new BoxFolder(BoxFileRequest.this.getAPI(), folderID);
                    boxFolder.getClass();
                    this.folder = boxFolder.new BoxFolder.Info(folderJSON);
                } else if (memberName.equals("is_description_required")) {
                    this.isDescriptionRequired = value.asBoolean();
                } else if (memberName.equals("is_email_required")) {
                    this.isEmailRequired = value.asBoolean();
                } else if (memberName.equals("status")) {
                    this.status = Status.fromJSONString(value.asString());
                } else if (memberName.equals("title")) {
                    this.title = value.asString();
                } else if (memberName.equals("updated_at")) {
                    this.updatedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("updated_by")) {
                    BoxUser user;
                    JsonObject userJSON = value.asObject();
                    String userID = userJSON.get("id").asString();
                    BoxUser boxUser = user = new BoxUser(BoxFileRequest.this.getAPI(), userID);
                    boxUser.getClass();
                    this.createdBy = boxUser.new BoxUser.Info(userJSON);
                } else if (memberName.equals("url")) {
                    this.path = value.asString();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static enum Status {
        ACTIVE("active"),
        INACTIVE("inactive");

        private final String jsonValue;

        private Status(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Status fromJSONString(String jsonValue) {
            return Status.valueOf(jsonValue.toUpperCase());
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }
}

