/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxWebLink;
import com.box.sdk.Filter;
import com.box.sdk.JSONIterator;
import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;

class BoxItemIterator
implements Iterator<BoxItem.Info> {
    private static final long LIMIT = 1000L;
    private final BoxAPIConnection api;
    private final JSONIterator jsonIterator;

    BoxItemIterator(BoxAPIConnection api, URL url) {
        this.api = api;
        this.jsonIterator = new JSONIterator(api, url, 1000L);
        this.jsonIterator.setFilter(new Filter<JsonObject>(){

            @Override
            public boolean shouldInclude(JsonObject jsonObject) {
                String type = jsonObject.get("type").asString();
                return type.equals("file") || type.equals("folder") || type.equals("web_link");
            }
        });
    }

    BoxItemIterator(BoxAPIConnection api, URL url, long limit, long offset) {
        this.api = api;
        this.jsonIterator = new JSONIterator(api, url, limit, offset);
        this.jsonIterator.setFilter(new Filter<JsonObject>(){

            @Override
            public boolean shouldInclude(JsonObject jsonObject) {
                String type = jsonObject.get("type").asString();
                return type.equals("file") || type.equals("folder") || type.equals("web_link");
            }
        });
    }

    @Override
    public boolean hasNext() {
        return this.jsonIterator.hasNext();
    }

    @Override
    public BoxItem.Info next() {
        BoxItem.Info nextItemInfo;
        JsonObject nextJSONObject = this.jsonIterator.next();
        String type = nextJSONObject.get("type").asString();
        String id = nextJSONObject.get("id").asString();
        if (type.equals("folder")) {
            BoxFolder folder;
            BoxFolder boxFolder = folder = new BoxFolder(this.api, id);
            boxFolder.getClass();
            nextItemInfo = new BoxFolder.Info(boxFolder, nextJSONObject);
        } else if (type.equals("file")) {
            BoxFile file;
            BoxFile boxFile = file = new BoxFile(this.api, id);
            boxFile.getClass();
            nextItemInfo = new BoxFile.Info(boxFile, nextJSONObject);
        } else if (type.equals("web_link")) {
            BoxWebLink link;
            BoxWebLink boxWebLink = link = new BoxWebLink(this.api, id);
            boxWebLink.getClass();
            nextItemInfo = boxWebLink.new BoxWebLink.Info(nextJSONObject);
        } else {
            assert (false) : "Unsupported item type: " + type;
            throw new BoxAPIException("Unsupported item type: " + type);
        }
        return nextItemInfo;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

