/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="task_assignment")
public class BoxTaskAssignment
extends BoxResource {
    public static final URLTemplate TASK_ASSIGNMENT_URL_TEMPLATE = new URLTemplate("task_assignments/%s");

    public BoxTaskAssignment(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public void delete() {
        URL url = TASK_ASSIGNMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public Info getInfo() {
        URL url = TASK_ASSIGNMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = TASK_ASSIGNMENT_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public void updateInfo(Info info) {
        URL url = TASK_ASSIGNMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public static enum ResolutionState {
        COMPLETED("completed"),
        INCOMPLETE("incomplete"),
        APPROVED("approved"),
        REJECTED("rejected");

        private final String jsonValue;

        private ResolutionState(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static ResolutionState fromJSONString(String jsonValue) {
            if (jsonValue.equals("completed")) {
                return COMPLETED;
            }
            if (jsonValue.equals("incomplete")) {
                return INCOMPLETE;
            }
            if (jsonValue.equals("approved")) {
                return APPROVED;
            }
            if (jsonValue.equals("rejected")) {
                return REJECTED;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid ResolutionState.");
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    public class Info
    extends BoxResource.Info {
        private BoxItem.Info item;
        private BoxUser.Info assignedTo;
        private String message;
        private Date completedAt;
        private Date assignedAt;
        private Date remindedAt;
        private ResolutionState resolutionState;
        private String status;
        private BoxUser.Info assignedBy;

        public Info() {
            super(BoxTaskAssignment.this);
        }

        public Info(String json) {
            super((BoxResource)BoxTaskAssignment.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxTaskAssignment.this, jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxTaskAssignment.this;
        }

        public BoxItem.Info getItem() {
            return this.item;
        }

        public BoxUser.Info getAssignedTo() {
            return this.assignedTo;
        }

        public String getMessage() {
            return this.message;
        }

        public Date getCompletedAt() {
            return this.completedAt;
        }

        public Date getAssignedAt() {
            return this.assignedAt;
        }

        public Date getRemindedAt() {
            return this.remindedAt;
        }

        public ResolutionState getResolutionState() {
            return this.resolutionState;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
            this.addPendingChange("status", status);
        }

        public BoxUser.Info getAssignedBy() {
            return this.assignedBy;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("item")) {
                    BoxFile file;
                    JsonObject itemJSON = value.asObject();
                    String itemID = itemJSON.get("id").asString();
                    BoxFile boxFile = file = new BoxFile(BoxTaskAssignment.this.getAPI(), itemID);
                    boxFile.getClass();
                    this.item = new BoxFile.Info(boxFile, itemJSON);
                } else if (memberName.equals("assigned_to")) {
                    BoxUser user;
                    JsonObject userJSON = value.asObject();
                    String userID = userJSON.get("id").asString();
                    BoxUser boxUser = user = new BoxUser(BoxTaskAssignment.this.getAPI(), userID);
                    boxUser.getClass();
                    this.assignedTo = new BoxUser.Info(boxUser, userJSON);
                } else if (memberName.equals("message")) {
                    this.message = value.asString();
                } else if (memberName.equals("completed_at")) {
                    this.completedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("assigned_at")) {
                    this.assignedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("reminded_at")) {
                    this.remindedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("resolution_state")) {
                    this.resolutionState = ResolutionState.fromJSONString(value.asString());
                } else if (memberName.equals("status")) {
                    this.status = value.asString();
                } else if (memberName.equals("assigned_by")) {
                    BoxUser user;
                    JsonObject userJSON = value.asObject();
                    String userID = userJSON.get("id").asString();
                    BoxUser boxUser = user = new BoxUser(BoxTaskAssignment.this.getAPI(), userID);
                    boxUser.getClass();
                    this.assignedBy = new BoxUser.Info(boxUser, userJSON);
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

