/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk.internal.utils;

import com.box.sdk.Metadata;
import com.box.sdk.Representation;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parsers {
    protected Parsers() {
    }

    public static Map<String, Map<String, Metadata>> parseAndPopulateMetadataMap(JsonObject jsonObject) {
        HashMap<String, Map<String, Metadata>> metadataMap = new HashMap<String, Map<String, Metadata>>();
        for (JsonObject.Member templateMember : jsonObject) {
            if (templateMember.getValue().isNull()) continue;
            String templateName = templateMember.getName();
            HashMap<String, Metadata> scopeMap = (HashMap<String, Metadata>)metadataMap.get(templateName);
            if (scopeMap == null) {
                scopeMap = new HashMap<String, Metadata>();
                metadataMap.put(templateName, scopeMap);
            }
            for (JsonObject.Member scopeMember : templateMember.getValue().asObject()) {
                String scope = scopeMember.getName();
                Metadata metadataObject = new Metadata(scopeMember.getValue().asObject());
                scopeMap.put(scope, metadataObject);
            }
        }
        return metadataMap;
    }

    public static List<Representation> parseRepresentations(JsonObject jsonObject) {
        ArrayList<Representation> representations = new ArrayList<Representation>();
        for (JsonValue representationJson : jsonObject.get("entries").asArray()) {
            Representation representation = new Representation(representationJson.asObject());
            representations.add(representation);
        }
        return representations;
    }
}

