/*
 * Decompiled with CFR 0.152.
 */
package com.blade.validator;

import com.blade.kit.PatternKit;
import com.blade.validator.SimpleValidation;
import com.blade.validator.Validation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Validators {
    private static final Map<String, String> I18N_MAP = new HashMap<String, String>();
    private static String i18nPrefix = "EN_";

    public static void useChinese() {
        i18nPrefix = "CN_";
    }

    public static <T> Validation<T> notNull() {
        return Validators.notNull(I18N_MAP.get(i18nPrefix + "NOT_NULL"));
    }

    public static <T> Validation<T> notNull(String msg) {
        return SimpleValidation.from(Objects::nonNull, msg);
    }

    public static Validation<String> notEmpty() {
        return Validators.notEmpty(I18N_MAP.get(i18nPrefix + "NOT_EMPTY"));
    }

    public static Validation<String> notEmpty(String msg) {
        return SimpleValidation.from(s -> null != s && !s.isEmpty(), msg);
    }

    public static Validation<String> moreThan(int size) {
        return Validators.notEmpty().and(Validators.moreThan(size, I18N_MAP.get(i18nPrefix + "MORE_THAN")));
    }

    public static Validation<String> moreThan(int size, String msg) {
        return Validators.notEmpty().and(SimpleValidation.from(s -> s.length() >= size, String.format(msg, size)));
    }

    public static Validation<String> lessThan(int size) {
        return Validators.lessThan(size, I18N_MAP.get(i18nPrefix + "LESS_THAN"));
    }

    public static Validation<String> lessThan(int size, String msg) {
        return Validators.notEmpty().and(SimpleValidation.from(s -> s.length() <= size, String.format(msg, size)));
    }

    public static Validation<String> length(int minSize, int maxSize) {
        return Validators.moreThan(minSize).and(Validators.lessThan(maxSize));
    }

    public static Validation<String> contains(String c) {
        return Validators.contains(c, I18N_MAP.get(i18nPrefix + "CONTAINS"));
    }

    public static Validation<String> contains(String c, String msg) {
        return Validators.notEmpty().and(SimpleValidation.from(s -> s.contains(c), String.format(msg, c)));
    }

    public static Validation<Integer> lowerThan(int max) {
        return Validators.lowerThan(max, I18N_MAP.get(i18nPrefix + "LOWER_THAN"));
    }

    public static Validation<Integer> lowerThan(int max, String msg) {
        return SimpleValidation.from(i -> i < max, String.format(msg, max));
    }

    public static Validation<Integer> greaterThan(int min) {
        return Validators.greaterThan(min, I18N_MAP.get(i18nPrefix + "GREATER_THAN"));
    }

    public static Validation<Integer> greaterThan(int min, String msg) {
        return SimpleValidation.from(i -> i > min, String.format(msg, min));
    }

    public static Validation<Integer> range(int min, int max) {
        return Validators.greaterThan(min).and(Validators.lowerThan(max));
    }

    public static Validation<String> isEmail() {
        return Validators.isEmail(I18N_MAP.get(i18nPrefix + "IS_EMAIL"));
    }

    public static Validation<String> isEmail(String msg) {
        return Validators.notEmpty().and(SimpleValidation.from(PatternKit::isEmail, msg));
    }

    public static Validation<String> isURL() {
        return Validators.isURL(I18N_MAP.get(i18nPrefix + "IS_URL"));
    }

    public static Validation<String> isURL(String msg) {
        return Validators.notEmpty().and(SimpleValidation.from(PatternKit::isURL, msg));
    }

    private Validators() {
    }

    static {
        I18N_MAP.put("CN_NOT_NULL", "\u4e0d\u5141\u8bb8\u4e3a NULL");
        I18N_MAP.put("CN_NOT_EMPTY", "\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        I18N_MAP.put("CN_MORE_THAN", "\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e %s \u4e2a\u5b57\u7b26");
        I18N_MAP.put("CN_LESS_THAN", "\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e %s \u4e2a\u5b57\u7b26");
        I18N_MAP.put("CN_CONTAINS", "\u5fc5\u987b\u5305\u542b %s \u5b57\u7b26");
        I18N_MAP.put("CN_LOWER_THAN", "\u5fc5\u987b\u5c0f\u4e8e %s");
        I18N_MAP.put("CN_GREATER_THAN", "\u5fc5\u987b\u5927\u4e8e %s");
        I18N_MAP.put("CN_IS_EMAIL", "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u90ae\u7bb1");
        I18N_MAP.put("CN_IS_URL", "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684URL");
        I18N_MAP.put("EN_NOT_NULL", "must not be null.");
        I18N_MAP.put("EN_NOT_EMPTY", "must not be empty.");
        I18N_MAP.put("EN_MORE_THAN", "must have more than %s chars.");
        I18N_MAP.put("EN_LESS_THAN", "must have less than %s chars.");
        I18N_MAP.put("EN_CONTAINS", "must contain %s");
        I18N_MAP.put("EN_LOWER_THAN", "must be lower than %s.");
        I18N_MAP.put("EN_GREATER_THAN", "must be greater than %s.");
        I18N_MAP.put("EN_IS_EMAIL", "must be a email.");
        I18N_MAP.put("EN_IS_URL", "must be a url.");
    }
}

