/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.exception.ForbiddenException;
import com.blade.exception.NotFoundException;
import com.blade.kit.BladeKit;
import com.blade.kit.ConvertKit;
import com.blade.kit.DateKit;
import com.blade.kit.IOKit;
import com.blade.kit.PathKit;
import com.blade.kit.StringKit;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.RequestHandler;
import com.blade.mvc.http.Request;
import com.blade.server.netty.HttpConst;
import com.blade.server.netty.ProgressiveFutureListener;
import com.blade.server.netty.StaticInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHandler
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticFileHandler.class);
    private static final String STYLE = "body{background:#fff;margin:0;padding:30px;-webkit-font-smoothing:antialiased;font-family:Menlo,Consolas,monospace}main{max-width:920px}header{display:flex;justify-content:space-between}#toggle{display:none;cursor:pointer}#toggle:before{display:inline-block;content:url(\"data:image/svg+xml; utf8, <svg height='24px' version='1.1' viewBox='0 0 24 24' width='24px' xmlns='http://www.w3.org/2000/svg'><g fill='none' fill-rule='evenodd' stroke='none' stroke-width='1'><g transform='translate(-431.000000, -479.000000)'><g transform='translate(215.000000, 119.000000)'/><path d='M432,480 L432,486 L438,486 L438,480 L432,480 Z M440,480 L440,486 L446,486 L446,480 L440,480 Z M448,480 L448,486 L454,486 L454,480 L448,480 Z M449,481 L449,485 L453,485 L453,481 L449,481 Z M441,481 L441,485 L445,485 L445,481 L441,481 Z M433,481 L433,485 L437,485 L437,481 L433,481 Z M432,488 L432,494 L438,494 L438,488 L432,488 Z M440,488 L440,494 L446,494 L446,488 L440,488 Z M448,488 L448,494 L454,494 L454,488 L448,488 Z M449,489 L449,493 L453,493 L453,489 L449,489 Z M441,489 L441,493 L445,493 L445,489 L441,489 Z M433,489 L433,493 L437,493 L437,489 L433,489 Z M432,496 L432,502 L438,502 L438,496 L432,496 Z M440,496 L440,502 L446,502 L446,496 L440,496 Z M448,496 L448,502 L454,502 L454,496 L448,496 Z M449,497 L449,501 L453,501 L453,497 L449,497 Z M441,497 L441,501 L445,501 L445,497 L441,497 Z M433,497 L433,501 L437,501 L437,497 L433,497 Z' fill='#000000'/></g></g></svg>\")}#toggle.single-column:before{content:url(\"data:image/svg+xml; utf8, <svg height='24px' viewBox='0 0 24 24' width='24px' xmlns='http://www.w3.org/2000/svg'><g fill='none' fill-rule='evenodd' id='miu' stroke='none' stroke-width='1'><g transform='translate(-359.000000, -479.000000)'><g transform='translate(215.000000, 119.000000)'/><path d='M360.577138,485 C360.258394,485 360,485.221932 360,485.5 C360,485.776142 360.262396,486 360.577138,486 L381.422862,486 C381.741606,486 382,485.778068 382,485.5 C382,485.223858 381.737604,485 381.422862,485 L360.577138,485 L360.577138,485 Z M360.577138,490 C360.258394,490 360,490.221932 360,490.5 C360,490.776142 360.262396,491 360.577138,491 L381.422862,491 C381.741606,491 382,490.778068 382,490.5 C382,490.223858 381.737604,490 381.422862,490 L360.577138,490 L360.577138,490 Z M360.577138,495 C360.258394,495 360,495.221932 360,495.5 C360,495.776142 360.262396,496 360.577138,496 L381.422862,496 C381.741606,496 382,495.778068 382,495.5 C382,495.223858 381.737604,495 381.422862,495 L360.577138,495 L360.577138,495 Z' fill='#000000'/></g></g></svg>\")}a{color:#1A00F2;text-decoration:none}h1{font-size:18px;font-weight:500;margin-top:0;color:#000;font-family:-apple-system,Helvetica;display:flex}h1 a{color:inherit;font-weight:700;border-bottom:1px dashed transparent}h1 a::after{content:'/'}h1 a:hover{color:#7d7d7d}h1 i{font-style:normal}ul{margin:0;padding:20px 0 0 0}ul.single-column{flex-direction:column}ul li{list-style:none;padding:10px 0;font-size:14px;display:flex;justify-content:space-between}ul li i{color:#9B9B9B;font-size:11px;display:block;font-style:normal;white-space:nowrap;padding-left:15px}ul a{color:#1A00F2;white-space:nowrap;overflow:hidden;display:block;text-overflow:ellipsis}ul a::before{content:url(\"data:image/svg+xml; utf8, <svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 64 64'><g fill='transparent' stroke='currentColor' stroke-miterlimit='10'><path stroke-width='4' d='M50.46 56H13.54V8h22.31a4.38 4.38 0 0 1 3.1 1.28l10.23 10.24a4.38 4.38 0 0 1 1.28 3.1z'/><path stroke-width='2' d='M35.29 8.31v14.72h14.06'/></g></svg>\");display:inline-block;vertical-align:middle;margin-right:10px}ul a:hover{color:#000}ul a[class=''] + i{display:none}ul a[class='']::before{content:url(\"data:image/svg+xml; utf8, <svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 64 64'><path fill='transparent' stroke='currentColor' stroke-width='4' stroke-miterlimit='10' d='M56 53.71H8.17L8 21.06a2.13 2.13 0 0 1 2.13-2.13h2.33l2.13-4.28A4.78 4.78 0 0 1 18.87 12h9.65a4.78 4.78 0 0 1 4.28 2.65l2.13 4.28h17.36a3.55 3.55 0 0 1 3.55 3.55z'/></svg>\")}ul a[class='gif']::before,ul a[class='jpg']::before,ul a[class='png']::before,ul a[class='svg']::before{content:url(\"data:image/svg+xml; utf8, <svg width='16' height='16' viewBox='0 0 80 80' xmlns='http://www.w3.org/2000/svg' fill='none' stroke='currentColor' stroke-width='5' stroke-linecap='round' stroke-linejoin='round'><rect x='6' y='6' width='68' height='68' rx='5' ry='5'/><circle cx='24' cy='24' r='8'/><path d='M73 49L59 34 37 52M53 72L27 42 7 58'/></svg>\");width:16px}@media (min-width:768px){#toggle{display:inline-block}ul{display:flex;flex-wrap:wrap}ul li{width:230px;padding-right:20px}ul.single-column li{width:auto}}@media (min-width:992px){body{padding:45px}h1{font-size:15px}ul li{font-size:13px;box-sizing:border-box;justify-content:flex-start}ul li:hover i{opacity:1}ul li i{font-size:10px;opacity:0;margin-left:10px;margin-top:3px;padding-left:0}}";
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[^-._]?[^<>&\"]*");
    private static JarFile CACHE_JAR_FILE;
    private final boolean showFileList;
    private final long httpCacheSeconds;
    private static final Pattern INSECURE_URI;

    public StaticFileHandler(Blade blade) {
        this.showFileList = blade.environment().getBoolean("mvc.statics.show-list", false);
        this.httpCacheSeconds = blade.environment().getLong("http.cache.timeout", 2592000L);
    }

    @Override
    public void handle(WebContext webContext) throws Exception {
        ChannelFuture lastContentFuture;
        ChannelFuture sendFileFuture;
        RandomAccessFile raf;
        Request request = webContext.getRequest();
        ChannelHandlerContext ctx = webContext.getChannelHandlerContext();
        if (!"GET".equals(request.method())) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        Instant start = Instant.now();
        String uri = URLDecoder.decode(request.uri(), "UTF-8");
        String method = StringKit.padRight(request.method(), 6);
        String cleanURL = this.getCleanURL(request, uri);
        if (cleanURL.startsWith("/webjars/")) {
            InputStream input = this.getResourceStreamFromJar(uri);
            this.writeWithJarFile(request, ctx, uri, start, cleanURL, method, input);
            return;
        }
        if (BladeKit.runtimeIsJAR()) {
            InputStream input = StaticFileHandler.class.getResourceAsStream(cleanURL);
            this.writeWithJarFile(request, ctx, uri, start, cleanURL, method, input);
            return;
        }
        String path = StaticFileHandler.sanitizeUri(cleanURL);
        if (path == null) {
            BladeKit.log403(log, method, uri);
            throw new ForbiddenException();
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            File resourcesDirectory = this.getGradleResourcesDirectory();
            if (resourcesDirectory.isDirectory()) {
                file = new File(resourcesDirectory.getPath() + "/" + cleanURL.substring(1));
                if (file.isHidden() || !file.exists()) {
                    throw new NotFoundException(uri);
                }
            } else {
                throw new NotFoundException(uri);
            }
        }
        if (file.isDirectory() && this.showFileList) {
            StaticFileHandler.sendListing(ctx, uri, this.getFileMetas(file), cleanURL);
            return;
        }
        if (!file.isFile()) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        if (this.isHttp304(ctx, request, file.length(), file.lastModified())) {
            BladeKit.log304(log, method, uri);
            return;
        }
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        StaticFileHandler.setContentTypeHeader((HttpResponse)httpResponse, file);
        this.setDateAndCacheHeaders((HttpResponse)httpResponse, file);
        if (request.useGZIP()) {
            File output = new File(file.getPath() + ".gz");
            IOKit.compressGZIP(file, output);
            file = output;
            this.setGzip((HttpResponse)httpResponse);
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignore) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        httpResponse.headers().set((CharSequence)HttpConst.CONTENT_LENGTH, (Object)fileLength);
        if (request.keepAlive()) {
            httpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
        }
        ctx.write((Object)httpResponse);
        if (ctx.pipeline().get(SslHandler.class) == null) {
            sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
        }
        sendFileFuture.addListener((GenericFutureListener)ProgressiveFutureListener.build(raf));
        if (!request.keepAlive()) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        BladeKit.log200AndCost(log, start, method, uri);
    }

    private List<FileMeta> getFileMetas(File file) {
        if (file.isHidden() || !file.canRead() || file.listFiles() == null) {
            return Collections.emptyList();
        }
        return Arrays.stream((Object[])Objects.requireNonNull(file.listFiles())).filter(f -> !f.isHidden() && f.canRead()).map(FileMeta::buildByFile).collect(Collectors.toList());
    }

    private File getGradleResourcesDirectory() {
        return new File(new File(Const.class.getResource("/").getPath()).getParent() + "/resources");
    }

    private String getCleanURL(Request request, String uri) {
        if ((uri = PathKit.cleanPath(uri.replaceFirst(request.contextPath(), "/"))).endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    private InputStream getResourceStreamFromJar(String uri) {
        return StaticFileHandler.class.getResourceAsStream("/META-INF/resources" + uri);
    }

    private URL getURLFromJar(String uri) {
        return StaticFileHandler.class.getClassLoader().getResource(uri);
    }

    private void writeWithJarFile(Request request, ChannelHandlerContext ctx, String uri, Instant start, String cleanUri, String method, InputStream input) throws IOException {
        if (null == input) {
            throw new NotFoundException(uri);
        }
        if (this.writeJarResource(ctx, request, cleanUri, input)) {
            BladeKit.log200AndCost(log, start, method, uri);
        }
    }

    private boolean writeJarResource(ChannelHandlerContext ctx, Request request, String cleanUri, InputStream input) throws IOException {
        try {
            StaticInputStream staticInputStream = new StaticInputStream(input);
            int size = staticInputStream.size();
            if (this.isHttp304(ctx, request, size, -1L)) {
                BladeKit.log304(log, request.method(), cleanUri);
                return false;
            }
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, staticInputStream.asByteBuf());
            this.setDateAndCacheHeaders((HttpResponse)httpResponse, null);
            String contentType = StringKit.mimeType(cleanUri);
            if (null != contentType) {
                httpResponse.headers().set((CharSequence)HttpConst.CONTENT_TYPE, (Object)contentType);
            }
            httpResponse.headers().set((CharSequence)HttpConst.CONTENT_LENGTH, (Object)size);
            if (request.keepAlive()) {
                httpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
            }
            ctx.writeAndFlush((Object)httpResponse);
            return true;
        }
        catch (NullPointerException e) {
            String jarPath = cleanUri.substring(1);
            URL dirURL = this.getURLFromJar(jarPath);
            if (null != dirURL && dirURL.getProtocol().equals("jar")) {
                List<FileMeta> listFiles = this.getResourceListing(dirURL, jarPath);
                StaticFileHandler.sendListing(ctx, request.uri(), listFiles, cleanUri);
                return true;
            }
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private boolean isHttp304(ChannelHandlerContext ctx, Request request, long size, long lastModified) {
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        String ifModifiedSince = request.header("If-Modified-Since");
        if (StringKit.isNotEmpty(ifModifiedSince) && this.httpCacheSeconds > 0L && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = this.format(ifModifiedSince, "EEE, dd MMM yyyy HH:mm:ss zzz")).getTime() / 1000L) == lastModified / 1000L) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
            String contentType = StringKit.mimeType(request.uri());
            if (null != contentType) {
                response.headers().set((CharSequence)HttpConst.CONTENT_TYPE, (Object)contentType);
            }
            response.headers().set((CharSequence)HttpConst.DATE, (Object)DateKit.gmtDate());
            response.headers().set((CharSequence)HttpConst.CONTENT_LENGTH, (Object)size);
            if (request.keepAlive()) {
                response.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
            }
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return true;
        }
        return false;
    }

    public Date format(String date, String pattern) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(pattern, Locale.US);
        LocalDateTime formatted = LocalDateTime.parse(date, fmt);
        Instant instant = formatted.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    private void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        response.headers().set((CharSequence)HttpConst.DATE, (Object)DateKit.gmtDate());
        if (this.httpCacheSeconds > 0L) {
            response.headers().set((CharSequence)HttpConst.EXPIRES, (Object)DateKit.gmtDate(LocalDateTime.now().plusSeconds(this.httpCacheSeconds)));
            response.headers().set((CharSequence)HttpConst.CACHE_CONTROL, (Object)("private, max-age=" + this.httpCacheSeconds));
            if (null != fileToCache) {
                response.headers().set((CharSequence)HttpConst.LAST_MODIFIED, (Object)DateKit.gmtDate(new Date(fileToCache.lastModified())));
            } else {
                response.headers().set((CharSequence)HttpConst.LAST_MODIFIED, (Object)DateKit.gmtDate(LocalDateTime.now().plusDays(-1L)));
            }
        }
    }

    List<FileMeta> getResourceListing(URL dirURL, String path) throws IOException {
        ArrayList<FileMeta> listFiles = new ArrayList<FileMeta>();
        if (null == CACHE_JAR_FILE) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            CACHE_JAR_FILE = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        }
        Enumeration<JarEntry> entries = CACHE_JAR_FILE.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (!name.startsWith(path) || name.equals(path + "/")) continue;
            FileMeta fileMeta = new FileMeta();
            fileMeta.name = name.substring(path.length() + 1);
            fileMeta.isDirectory = jarEntry.isDirectory();
            if (!fileMeta.isDirectory) {
                fileMeta.length = jarEntry.getSize();
            }
            listFiles.add(fileMeta);
        }
        return listFiles;
    }

    private static void sendListing(ChannelHandlerContext ctx, String uri, List<FileMeta> listFiles, String dirPath) {
        String[] dirs;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpConst.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        StringBuilder buf = new StringBuilder().append("<!DOCTYPE html>\r\n").append("<html><head>").append("<meta charset='utf-8' />").append("<meta name='viewport' content='width=device-width, initial-scale=1'>").append("<title>").append("Files within: ").append(dirPath).append("</title><style>body{background:#fff;margin:0;padding:30px;-webkit-font-smoothing:antialiased;font-family:Menlo,Consolas,monospace}main{max-width:920px}header{display:flex;justify-content:space-between}#toggle{display:none;cursor:pointer}#toggle:before{display:inline-block;content:url(\"data:image/svg+xml; utf8, <svg height='24px' version='1.1' viewBox='0 0 24 24' width='24px' xmlns='http://www.w3.org/2000/svg'><g fill='none' fill-rule='evenodd' stroke='none' stroke-width='1'><g transform='translate(-431.000000, -479.000000)'><g transform='translate(215.000000, 119.000000)'/><path d='M432,480 L432,486 L438,486 L438,480 L432,480 Z M440,480 L440,486 L446,486 L446,480 L440,480 Z M448,480 L448,486 L454,486 L454,480 L448,480 Z M449,481 L449,485 L453,485 L453,481 L449,481 Z M441,481 L441,485 L445,485 L445,481 L441,481 Z M433,481 L433,485 L437,485 L437,481 L433,481 Z M432,488 L432,494 L438,494 L438,488 L432,488 Z M440,488 L440,494 L446,494 L446,488 L440,488 Z M448,488 L448,494 L454,494 L454,488 L448,488 Z M449,489 L449,493 L453,493 L453,489 L449,489 Z M441,489 L441,493 L445,493 L445,489 L441,489 Z M433,489 L433,493 L437,493 L437,489 L433,489 Z M432,496 L432,502 L438,502 L438,496 L432,496 Z M440,496 L440,502 L446,502 L446,496 L440,496 Z M448,496 L448,502 L454,502 L454,496 L448,496 Z M449,497 L449,501 L453,501 L453,497 L449,497 Z M441,497 L441,501 L445,501 L445,497 L441,497 Z M433,497 L433,501 L437,501 L437,497 L433,497 Z' fill='#000000'/></g></g></svg>\")}#toggle.single-column:before{content:url(\"data:image/svg+xml; utf8, <svg height='24px' viewBox='0 0 24 24' width='24px' xmlns='http://www.w3.org/2000/svg'><g fill='none' fill-rule='evenodd' id='miu' stroke='none' stroke-width='1'><g transform='translate(-359.000000, -479.000000)'><g transform='translate(215.000000, 119.000000)'/><path d='M360.577138,485 C360.258394,485 360,485.221932 360,485.5 C360,485.776142 360.262396,486 360.577138,486 L381.422862,486 C381.741606,486 382,485.778068 382,485.5 C382,485.223858 381.737604,485 381.422862,485 L360.577138,485 L360.577138,485 Z M360.577138,490 C360.258394,490 360,490.221932 360,490.5 C360,490.776142 360.262396,491 360.577138,491 L381.422862,491 C381.741606,491 382,490.778068 382,490.5 C382,490.223858 381.737604,490 381.422862,490 L360.577138,490 L360.577138,490 Z M360.577138,495 C360.258394,495 360,495.221932 360,495.5 C360,495.776142 360.262396,496 360.577138,496 L381.422862,496 C381.741606,496 382,495.778068 382,495.5 C382,495.223858 381.737604,495 381.422862,495 L360.577138,495 L360.577138,495 Z' fill='#000000'/></g></g></svg>\")}a{color:#1A00F2;text-decoration:none}h1{font-size:18px;font-weight:500;margin-top:0;color:#000;font-family:-apple-system,Helvetica;display:flex}h1 a{color:inherit;font-weight:700;border-bottom:1px dashed transparent}h1 a::after{content:'/'}h1 a:hover{color:#7d7d7d}h1 i{font-style:normal}ul{margin:0;padding:20px 0 0 0}ul.single-column{flex-direction:column}ul li{list-style:none;padding:10px 0;font-size:14px;display:flex;justify-content:space-between}ul li i{color:#9B9B9B;font-size:11px;display:block;font-style:normal;white-space:nowrap;padding-left:15px}ul a{color:#1A00F2;white-space:nowrap;overflow:hidden;display:block;text-overflow:ellipsis}ul a::before{content:url(\"data:image/svg+xml; utf8, <svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 64 64'><g fill='transparent' stroke='currentColor' stroke-miterlimit='10'><path stroke-width='4' d='M50.46 56H13.54V8h22.31a4.38 4.38 0 0 1 3.1 1.28l10.23 10.24a4.38 4.38 0 0 1 1.28 3.1z'/><path stroke-width='2' d='M35.29 8.31v14.72h14.06'/></g></svg>\");display:inline-block;vertical-align:middle;margin-right:10px}ul a:hover{color:#000}ul a[class=''] + i{display:none}ul a[class='']::before{content:url(\"data:image/svg+xml; utf8, <svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 64 64'><path fill='transparent' stroke='currentColor' stroke-width='4' stroke-miterlimit='10' d='M56 53.71H8.17L8 21.06a2.13 2.13 0 0 1 2.13-2.13h2.33l2.13-4.28A4.78 4.78 0 0 1 18.87 12h9.65a4.78 4.78 0 0 1 4.28 2.65l2.13 4.28h17.36a3.55 3.55 0 0 1 3.55 3.55z'/></svg>\")}ul a[class='gif']::before,ul a[class='jpg']::before,ul a[class='png']::before,ul a[class='svg']::before{content:url(\"data:image/svg+xml; utf8, <svg width='16' height='16' viewBox='0 0 80 80' xmlns='http://www.w3.org/2000/svg' fill='none' stroke='currentColor' stroke-width='5' stroke-linecap='round' stroke-linejoin='round'><rect x='6' y='6' width='68' height='68' rx='5' ry='5'/><circle cx='24' cy='24' r='8'/><path d='M73 49L59 34 37 52M53 72L27 42 7 58'/></svg>\");width:16px}@media (min-width:768px){#toggle{display:inline-block}ul{display:flex;flex-wrap:wrap}ul li{width:230px;padding-right:20px}ul.single-column li{width:auto}}@media (min-width:992px){body{padding:45px}h1{font-size:15px}ul li{font-size:13px;box-sizing:border-box;justify-content:flex-start}ul li:hover i{opacity:1}ul li i{font-size:10px;opacity:0;margin-left:10px;margin-top:3px;padding-left:0}}</style></head><body>").append("<main><header><h1><i>Index of&nbsp;</i>");
        for (String s : dirs = uri.split("/")) {
            if (StringKit.isEmpty(s)) continue;
            String path = uri.substring(0, uri.indexOf(s) + s.length());
            buf.append("<a href='" + path + "'>" + s + "</a>");
        }
        buf.append("</h1>");
        buf.append("<a id='toggle' title='click to toggle the view'></a>");
        buf.append("</header>");
        buf.append("<ul id='files' class='single-column'>");
        if (dirs.length > 2) {
            String parent = uri.substring(0, uri.lastIndexOf("/"));
            buf.append("<li><a href='" + (String)parent + "' title='' class=''>..<i></i></li>");
        }
        for (FileMeta f : listFiles) {
            String name = f.name;
            if (!ALLOWED_FILE_NAME.matcher(name).matches()) continue;
            String subPath = (uri + "/" + name).replace("//", "/");
            buf.append("<li><a href='").append(subPath).append("' title='").append(name).append("'");
            if (f.isDirectory) {
                buf.append(" class=''>");
                buf.append(name).append("<i></i></li>");
                continue;
            }
            buf.append(" class='css'>");
            String size = ConvertKit.byte2FitMemoryString(f.length);
            buf.append(name).append("</a><i>");
            buf.append(size).append("</i></li>");
        }
        buf.append("</ul>");
        buf.append("</main>");
        buf.append("<script type='text/javascript'>");
        buf.append("(function() {");
        buf.append("toggle.addEventListener('click', function() {");
        buf.append("files.classList.toggle('single-column');");
        buf.append("toggle.classList.toggle('single-column');");
        buf.append("});");
        buf.append("})();");
        buf.append("</script>");
        buf.append("</body></html>");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8);
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpConst.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static String sanitizeUri(String uri) {
        if (uri.isEmpty() || uri.charAt(0) != '/') {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        String path = Const.CLASSPATH + File.separator + uri.substring(1);
        return path.replace("//", "/");
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String contentType = StringKit.mimeType(file.getName());
        if (null == contentType) {
            contentType = URLConnection.guessContentTypeFromName(file.getName());
        }
        response.headers().set((CharSequence)HttpConst.CONTENT_TYPE, (Object)contentType);
    }

    private void setGzip(HttpResponse response) {
        response.headers().set((CharSequence)HttpConst.CONTENT_ENCODING, (Object)"gzip");
    }

    static {
        INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    }

    static class FileMeta {
        boolean isDirectory;
        String name;
        long length;

        FileMeta() {
        }

        static FileMeta buildByFile(File f) {
            FileMeta fileMeta = new FileMeta();
            fileMeta.name = f.getName();
            fileMeta.isDirectory = f.isDirectory();
            if (f.isFile()) {
                fileMeta.length = f.length();
            }
            return fileMeta;
        }
    }
}

