/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.mvc.handler.ExceptionHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRequestHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger log = LoggerFactory.getLogger(MergeRequestHandler.class);
    private com.blade.mvc.http.HttpRequest httpRequest;

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            this.httpRequest = new com.blade.mvc.http.HttpRequest();
            this.httpRequest.setNettyRequest((HttpRequest)msg);
            return;
        }
        if (null != this.httpRequest && msg instanceof HttpContent) {
            this.httpRequest.appendContent((HttpContent)msg);
        }
        if (msg instanceof LastHttpContent) {
            if (null != this.httpRequest) {
                ctx.fireChannelRead((Object)this.httpRequest);
            } else {
                ctx.fireChannelRead((Object)msg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.isResetByPeer(cause)) {
            log.error(cause.getMessage(), cause);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)500));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

