/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.kit.BladeKit;
import com.blade.kit.ReflectKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.annotation.DeleteRoute;
import com.blade.mvc.annotation.GetRoute;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.annotation.PostRoute;
import com.blade.mvc.annotation.PutRoute;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.route.RouteStruct;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBuilder {
    private static final Logger log = LoggerFactory.getLogger(RouteBuilder.class);
    private RouteMatcher routeMatcher;

    public RouteBuilder(RouteMatcher routeMatcher) {
        this.routeMatcher = routeMatcher;
    }

    public void addWebHook(Class<?> webHook, String pattern) {
        Method before = ReflectKit.getMethod(webHook, HttpMethod.BEFORE.name().toLowerCase(), RouteContext.class);
        Method after = ReflectKit.getMethod(webHook, HttpMethod.AFTER.name().toLowerCase(), RouteContext.class);
        this.routeMatcher.addRoute(Route.builder().targetType(webHook).action(before).path(pattern).httpMethod(HttpMethod.BEFORE).build());
        this.routeMatcher.addRoute(Route.builder().targetType(webHook).action(after).path(pattern).httpMethod(HttpMethod.AFTER).build());
    }

    public void addRouter(Class<?> routeType, Object controller) {
        Method[] methods = routeType.getDeclaredMethods();
        if (BladeKit.isEmpty(methods)) {
            return;
        }
        String nameSpace = null;
        String suffix = null;
        if (null != routeType.getAnnotation(Path.class)) {
            nameSpace = routeType.getAnnotation(Path.class).value();
            suffix = routeType.getAnnotation(Path.class).suffix();
        }
        if (null == nameSpace) {
            log.warn("Route [{}] not path annotation", (Object)routeType.getName());
            return;
        }
        for (Method method : methods) {
            com.blade.mvc.annotation.Route mapping = method.getAnnotation(com.blade.mvc.annotation.Route.class);
            GetRoute getRoute = method.getAnnotation(GetRoute.class);
            PostRoute postRoute = method.getAnnotation(PostRoute.class);
            PutRoute putRoute = method.getAnnotation(PutRoute.class);
            DeleteRoute deleteRoute = method.getAnnotation(DeleteRoute.class);
            this.parseRoute(RouteStruct.builder().mapping(mapping).getRoute(getRoute).postRoute(postRoute).putRoute(putRoute).deleteRoute(deleteRoute).nameSpace(nameSpace).suffix(suffix).routeType(routeType).controller(controller).method(method).build());
        }
    }

    private void parseRoute(RouteStruct routeStruct) {
        HttpMethod methodType = routeStruct.getMethod();
        String[] paths = routeStruct.getPaths();
        if (paths.length > 0) {
            for (String path : paths) {
                String pathV = this.getRoutePath(path, routeStruct.nameSpace, routeStruct.suffix);
                this.routeMatcher.addRoute(Route.builder().target(routeStruct.controller).targetType(routeStruct.routeType).action(routeStruct.method).path(pathV).httpMethod(methodType).build());
            }
        }
    }

    private String getRoutePath(String value, String nameSpace, String suffix) {
        String path = value.startsWith("/") ? value : "/" + value;
        nameSpace = nameSpace.startsWith("/") ? nameSpace : "/" + nameSpace;
        path = nameSpace + path;
        path = path.replaceAll("[/]+", "/");
        path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        path = path + suffix;
        return path;
    }
}

