/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.BCrypt;

public final class PasswordKit {
    private static final int workload = 12;

    public static String hashPassword(String plaintext) {
        String salt = BCrypt.gensalt(12);
        return BCrypt.hashpw(plaintext, salt);
    }

    public static boolean checkPassword(String plaintext, String storedHash) {
        if (null == storedHash || !storedHash.startsWith("$2a$")) {
            throw new IllegalArgumentException("Invalid hash provided for comparison");
        }
        boolean password_verified = BCrypt.checkpw(plaintext, storedHash);
        return password_verified;
    }

    private PasswordKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

