/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.BladeKit;
import com.blade.kit.StringKit;
import com.blade.reflectasm.MethodAccess;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public final class BladeCache {
    private static final Map<SerializedLambda, String> CACHE_LAMBDA_NAME = new HashMap<SerializedLambda, String>(8);
    private static final Map<Class, MethodAccess> CLASS_METHOD_ACCESS_MAP = new HashMap<Class, MethodAccess>(8);
    private static final Map<String, String> PADDING_METHOD_STR = new HashMap<String, String>(6);

    public static String getPaddingMethod(String method) {
        return PADDING_METHOD_STR.get(method);
    }

    public static final MethodAccess getMethodAccess(Class clazz) {
        return CLASS_METHOD_ACCESS_MAP.computeIfAbsent(clazz, MethodAccess::get);
    }

    public static String getLambdaFieldName(SerializedLambda serializedLambda) {
        String name = CACHE_LAMBDA_NAME.get(serializedLambda);
        if (null != name) {
            return name;
        }
        String className = serializedLambda.getImplClass().replace("/", ".");
        String methodName = serializedLambda.getImplMethodName();
        String fieldName = BladeKit.methodToFieldName(methodName);
        try {
            Field field = Class.forName(className).getDeclaredField(fieldName);
            name = field.getName();
            CACHE_LAMBDA_NAME.put(serializedLambda, name);
            return name;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private BladeCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PADDING_METHOD_STR.put("GET", StringKit.padRight("GET", 6));
        PADDING_METHOD_STR.put("POST", StringKit.padRight("POST", 6));
        PADDING_METHOD_STR.put("DELETE", StringKit.padRight("DELETE", 6));
        PADDING_METHOD_STR.put("PUT", StringKit.padRight("PUT", 6));
        PADDING_METHOD_STR.put("OPTIONS", StringKit.padRight("OPTIONS", 6));
        PADDING_METHOD_STR.put("HEAD", StringKit.padRight("HEAD", 6));
    }
}

