/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import java.time.LocalDateTime;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.Ansi;
import org.slf4j.impl.Constant;
import org.slf4j.impl.OutputChoice;
import org.slf4j.impl.SimpleLoggerConfiguration;
import org.slf4j.impl.utils.LogUtils;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -632788891211436180L;
    static final int LOG_LEVEL_TRACE = 0;
    static final int LOG_LEVEL_DEBUG = 10;
    static final int LOG_LEVEL_INFO = 20;
    static final int LOG_LEVEL_WARN = 30;
    static final int LOG_LEVEL_ERROR = 40;
    protected static final int LOG_LEVEL_OFF = 50;
    private static boolean INITIALIZED = false;
    private static SimpleLoggerConfiguration CONFIG_PARAMS = null;
    protected int rootLevel;
    private transient String shortLogName = null;

    static void lazyInit() {
        if (INITIALIZED) {
            return;
        }
        INITIALIZED = true;
        SimpleLogger.init();
    }

    static void init() {
        CONFIG_PARAMS = new SimpleLoggerConfiguration();
        CONFIG_PARAMS.init();
    }

    SimpleLogger(String name) {
        this.name = name;
        String levelString = this.recursivelyComputeLevelString();
        this.rootLevel = levelString != null ? SimpleLoggerConfiguration.stringToLevel(levelString) : SimpleLogger.CONFIG_PARAMS.defaultLogLevel;
    }

    private String recursivelyComputeLevelString() {
        String tempName = this.name;
        String levelString = null;
        int indexOfLastDot = tempName.length();
        while (levelString == null && indexOfLastDot > -1) {
            tempName = tempName.substring(0, indexOfLastDot);
            levelString = CONFIG_PARAMS.getStringProp("com.blade.logger." + tempName, null);
            indexOfLastDot = String.valueOf(tempName).lastIndexOf(".");
        }
        return levelString;
    }

    private void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuffer buf = new StringBuffer(message.length() + 110);
        if (SimpleLogger.CONFIG_PARAMS.showDateTime) {
            String datetime = this.getFormattedDate() + ' ';
            if (SimpleLogger.CONFIG_PARAMS.disableColor) {
                buf.append(datetime);
            } else {
                buf.append(Ansi.White.format(datetime, new Object[0]));
            }
        }
        if (SimpleLogger.CONFIG_PARAMS.levelInBrackets) {
            buf.append("[ ");
        }
        if (SimpleLogger.CONFIG_PARAMS.disableColor) {
            buf.append(Constant.LOG_DESC_MAP.get(level + 50));
        } else {
            buf.append(Constant.LOG_DESC_MAP.get(level));
        }
        if (SimpleLogger.CONFIG_PARAMS.levelInBrackets) {
            buf.append(" ]");
        }
        buf.append(' ');
        if (SimpleLogger.CONFIG_PARAMS.showThreadName) {
            String threadName = SimpleLogger.CONFIG_PARAMS.disableColor ? LogUtils.getThreadPadding() : LogUtils.getColorThreadPadding();
            buf.append(threadName);
        }
        if (SimpleLogger.CONFIG_PARAMS.showShortLogName) {
            if (this.shortLogName == null) {
                this.shortLogName = SimpleLogger.CONFIG_PARAMS.disableColor ? LogUtils.getShortName(this.name) : LogUtils.getColorShortName(this.name);
            }
            buf.append(this.shortLogName);
        } else if (SimpleLogger.CONFIG_PARAMS.showLogName) {
            buf.append(String.valueOf(this.name)).append(" | ");
        }
        buf.append(message);
        this.write(buf, t);
    }

    private void write(StringBuffer buf, Throwable t) {
        if (SimpleLogger.CONFIG_PARAMS.outputChoice.outputChoiceType == OutputChoice.OutputChoiceType.FILE) {
            if (SimpleLogger.CONFIG_PARAMS.showConsole) {
                if (null != t) {
                    String stack = " " + LogUtils.stackTraceToString(t);
                    buf.append(stack);
                    System.err.println(buf.toString());
                } else {
                    System.out.println(buf.toString());
                    System.out.flush();
                }
            }
            if (null != SimpleLogger.CONFIG_PARAMS.fileRunner) {
                SimpleLogger.CONFIG_PARAMS.fileRunner.addToQueue(buf);
            }
        } else {
            PrintStream targetStream = SimpleLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream();
            targetStream.println(buf.toString());
            this.writeThrowable(t, targetStream);
            targetStream.flush();
        }
    }

    private void writeThrowable(Throwable t, PrintStream targetStream) {
        if (t != null) {
            t.printStackTrace();
            if (SimpleLogger.CONFIG_PARAMS.outputChoice.outputChoiceType == OutputChoice.OutputChoiceType.FILE) {
                t.printStackTrace(targetStream);
            }
        }
    }

    private String getFormattedDate() {
        return LocalDateTime.now().format(SimpleLogger.CONFIG_PARAMS.dateFormatter);
    }

    private void formatAndLog(int level, String format, Object arg1, Object arg2) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private void formatAndLog(int level, String format, Object ... arguments) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.rootLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public void trace(String msg) {
        this.log(0, msg, null);
    }

    public void trace(String format, Object param1) {
        this.formatAndLog(0, format, param1, (Object)null);
    }

    public void trace(String format, Object param1, Object param2) {
        this.formatAndLog(0, format, param1, param2);
    }

    public void trace(String format, Object ... argArray) {
        this.formatAndLog(0, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public void debug(String msg) {
        this.log(10, msg, null);
    }

    public void debug(String format, Object param1) {
        this.formatAndLog(10, format, param1, (Object)null);
    }

    public void debug(String format, Object param1, Object param2) {
        this.formatAndLog(10, format, param1, param2);
    }

    public void debug(String format, Object ... argArray) {
        this.formatAndLog(10, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(10, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public void info(String msg) {
        this.log(20, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(20, format, arg, (Object)null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(20, format, arg1, arg2);
    }

    public void info(String format, Object ... argArray) {
        this.formatAndLog(20, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(20, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public void warn(String msg) {
        this.log(30, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(30, format, arg, (Object)null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(30, format, arg1, arg2);
    }

    public void warn(String format, Object ... argArray) {
        this.formatAndLog(30, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(30, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    public void error(String msg) {
        this.log(40, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(40, format, arg, (Object)null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(40, format, arg1, arg2);
    }

    public void error(String format, Object ... argArray) {
        this.formatAndLog(40, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(40, msg, t);
    }

    public void log(LoggingEvent event) {
        int levelInt = event.getLevel().toInt();
        if (!this.isLevelEnabled(levelInt)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)event.getMessage(), (Object[])event.getArgumentArray(), (Throwable)event.getThrowable());
        this.log(levelInt, tp.getMessage(), event.getThrowable());
    }
}

