/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.util;

import com.blackducksoftware.integration.exception.IntegrationException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimedLRUCache<T, S> {
    private final ConcurrentHashMap<T, S> cache;
    private final ConcurrentHashMap<T, Timestamp> cacheKeyTTL;
    private Timestamp oldestKeyAge;
    private final int cacheTimeout;
    private final int cacheCapacity;

    public TimedLRUCache(int cacheCapacity, int cacheTimeout) {
        this.cacheCapacity = cacheCapacity;
        this.cacheTimeout = cacheTimeout;
        this.cache = new ConcurrentHashMap();
        this.cacheKeyTTL = new ConcurrentHashMap();
    }

    public S get(T key) throws IntegrationException {
        S value = this.cache.get(key);
        Timestamp staleTime = new Timestamp(System.currentTimeMillis() - (long)this.cacheTimeout);
        if (this.oldestKeyAge != null && this.oldestKeyAge.before(staleTime)) {
            this.removeStaleKeys(staleTime);
        }
        return value;
    }

    public void put(T key, S value) {
        if (this.cache.size() == this.cacheCapacity) {
            this.cache.remove(Collections.min(this.cacheKeyTTL.entrySet(), new Comparator<Map.Entry<T, Timestamp>>(){

                @Override
                public int compare(Map.Entry<T, Timestamp> entry1, Map.Entry<T, Timestamp> entry2) {
                    return entry1.getValue().getNanos() - entry2.getValue().getNanos();
                }
            }).getKey());
        }
        this.cache.put(key, value);
        this.cacheKeyTTL.put(key, new Timestamp(System.currentTimeMillis()));
    }

    private void removeStaleKeys(Timestamp staleTime) {
        this.oldestKeyAge = null;
        for (Map.Entry<T, Timestamp> entry : this.cacheKeyTTL.entrySet()) {
            T livingKey = entry.getKey();
            Timestamp keyStaleTime = entry.getValue();
            if (keyStaleTime.before(staleTime)) {
                this.cache.remove(livingKey);
                this.cacheKeyTTL.remove(livingKey);
                continue;
            }
            this.oldestKeyAge = this.oldestKeyAge == null || this.oldestKeyAge.after(keyStaleTime) ? keyStaleTime : this.oldestKeyAge;
        }
    }
}

