/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class ResourceUtil {
    public static InputStream getResourceAsStream(Class<?> clazz, String resourceName) throws IOException {
        return clazz.getClassLoader().getResourceAsStream(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
    }

    public static String getResourceAsString(String resourceName, String encoding) throws IOException {
        return ResourceUtil.getResourceAsString(resourceName, Charsets.toCharset((String)encoding));
    }

    public static String getResourceAsString(String resourceName, Charset encoding) throws IOException {
        InputStream inputStream = ResourceUtil.getResourceAsStream(resourceName);
        if (inputStream != null) {
            return IOUtils.toString((InputStream)inputStream, (Charset)encoding);
        }
        return null;
    }

    public static String getResourceAsString(Class<?> clazz, String resourceName, String encoding) throws IOException {
        return ResourceUtil.getResourceAsString(clazz, resourceName, Charsets.toCharset((String)encoding));
    }

    public static String getResourceAsString(Class<?> clazz, String resourceName, Charset encoding) throws IOException {
        InputStream inputStream = ResourceUtil.getResourceAsStream(clazz, resourceName);
        if (inputStream != null) {
            return IOUtils.toString((InputStream)inputStream, (Charset)encoding);
        }
        return null;
    }
}

