/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.util;

import com.blackducksoftware.integration.exception.IntegrationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PropertyUtil {
    public void setPropertyUsingSetter(Object instance, String propertyFieldName, String propertyValue) throws IntegrationException {
        Method[] methods;
        String setterName = "set" + StringUtils.capitalize((String)propertyFieldName);
        for (Method method : methods = instance.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.getName().equals(setterName) || (parameters = method.getParameterTypes()).length != 1) continue;
            String parameterName = parameters[0].getName();
            try {
                if ("java.lang.String".equals(parameterName)) {
                    method.invoke(instance, propertyValue);
                    continue;
                }
                if ("int".equals(parameterName)) {
                    method.invoke(instance, NumberUtils.toInt((String)propertyValue));
                    continue;
                }
                if ("long".equals(parameterName)) {
                    method.invoke(instance, NumberUtils.toLong((String)propertyValue));
                    continue;
                }
                if ("short".equals(parameterName)) {
                    method.invoke(instance, NumberUtils.toShort((String)propertyValue));
                    continue;
                }
                if ("double".equals(parameterName)) {
                    method.invoke(instance, NumberUtils.toDouble((String)propertyValue));
                    continue;
                }
                if ("float".equals(parameterName)) {
                    method.invoke(instance, Float.valueOf(NumberUtils.toFloat((String)propertyValue)));
                    continue;
                }
                if ("boolean".equals(parameterName)) {
                    method.invoke(instance, Boolean.parseBoolean(propertyValue));
                    continue;
                }
                if (!"char".equals(parameterName) || !StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
                method.invoke(instance, Character.valueOf(propertyValue.toCharArray()[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IntegrationException(String.format("Could not invoke %s with %s: %s", method.getName(), propertyValue, e.getMessage()));
            }
        }
    }
}

