/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.encryption;

import com.blackducksoftware.integration.exception.EncryptionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class EncryptionUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String EMBEDDED_SUN_KEY_FILE = "/Sun-Key.jceks";
    private static final String EMBEDDED_IBM_KEY_FILE = "/IBM-Key.jceks";
    private static final char[] KEY_PASS = new char[]{'b', 'l', 'a', 'c', 'k', 'd', 'u', 'c', 'k', '1', '2', '3', 'I', 'n', 't', 'e', 'g', 'r', 'a', 't', 'i', 'o', 'n'};

    public String alterString(String password, InputStream encryptionKeyStream, int cipherMode) throws EncryptionException {
        this.assertValidPassword(password);
        Key key = this.getKey(encryptionKeyStream);
        String alteredString = this.getAlteredString(password, cipherMode, key);
        return alteredString;
    }

    private void assertValidPassword(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("Please provide a non-blank password.");
        }
    }

    private Key getKey(InputStream encryptionKeyStream) throws EncryptionException {
        Key key = null;
        if (encryptionKeyStream != null) {
            try {
                key = this.retrieveKeyFromInputStream(encryptionKeyStream);
            }
            catch (Exception e) {
                throw new EncryptionException("Failed to retrieve the encryption key from the provided input stream.");
            }
        }
        try {
            InputStream inputStream = this.getResourceAsStream(EMBEDDED_SUN_KEY_FILE);
            key = this.retrieveKeyFromInputStream(inputStream);
        }
        catch (Exception e) {
            try {
                InputStream inputStream = this.getResourceAsStream(EMBEDDED_IBM_KEY_FILE);
                key = this.retrieveKeyFromInputStream(inputStream);
            }
            catch (Exception e1) {
                throw new EncryptionException("Failed to retrieve the encryption key from classpath", e);
            }
        }
        if (key == null) {
            throw new EncryptionException("The encryption key is null");
        }
        return key;
    }

    private String getAlteredString(String original, int cipherMode, Key key) throws EncryptionException {
        String alteredString = null;
        try {
            byte[] bytes = null;
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            bytes = original.getBytes(UTF8);
            int originalBytesLength = bytes.length;
            int bufferSize = originalBytesLength + (8 - originalBytesLength % 8);
            cipher.init(cipherMode, key);
            bytes = Arrays.copyOf(bytes, bufferSize);
            alteredString = 1 == cipherMode ? this.encrypt(cipher, bytes) : this.decrypt(cipher, bytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
        return alteredString;
    }

    private String encrypt(Cipher cipher, byte[] bytes) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buffer = cipher.doFinal(bytes);
        String encryptedPassword = new String(Base64.encodeBase64((byte[])buffer), UTF8).trim();
        return encryptedPassword;
    }

    private String decrypt(Cipher cipher, byte[] bytes) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buffer = cipher.doFinal(Base64.decodeBase64((byte[])bytes));
        String decryptedString = new String(buffer, UTF8).trim();
        return decryptedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key retrieveKeyFromInputStream(InputStream inputStream) throws NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyStoreException {
        try {
            Key key;
            KeyStore keystore = KeyStore.getInstance("JCEKS");
            keystore.load(inputStream, KEY_PASS);
            Key key2 = key = keystore.getKey("keyStore", KEY_PASS);
            return key2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private InputStream getResourceAsStream(String resourceName) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = EncryptionUtils.class.getResource(resourceName);
        }
        if (url != null) {
            return url.openStream();
        }
        throw new IOException("Failed to retrieve the resource from classpath");
    }
}

