/**
 * Hub Common
 *
 * Copyright (C) 2017 Black Duck Software, Inc.
 * http://www.blackducksoftware.com/
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.blackducksoftware.integration.hub.dataservice.vulnerability;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.component.ComponentRequestService;
import com.blackducksoftware.integration.hub.api.item.MetaService;
import com.blackducksoftware.integration.hub.api.vulnerability.VulnerabilityRequestService;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.response.ComponentSearchResultResponse;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.VulnerabilityView;
import com.blackducksoftware.integration.log.IntLogger;

public class VulnerabilityDataService {
    private final ComponentRequestService componentRequestService;
    private final VulnerabilityRequestService vulnerabilityRequestService;
    private final MetaService metaService;

    public VulnerabilityDataService(final IntLogger logger, final ComponentRequestService componentRequestService, final VulnerabilityRequestService vulnerabilityRequestService) {
        this.componentRequestService = componentRequestService;
        this.vulnerabilityRequestService = vulnerabilityRequestService;
        this.metaService = new MetaService(logger);
    }

    public List<VulnerabilityView> getVulnsFromComponentVersion(final String namespace, final String groupId, final String artifactId, final String version) throws IntegrationException {
        final ComponentSearchResultResponse component = componentRequestService.getExactComponentMatch(namespace, groupId, artifactId, version);
        if (component == null) {
            return null;
        }
        final String componentVersionURL = component.version;
        if (componentVersionURL != null) {
            final ComponentVersionView componentVersion = componentRequestService.getItem(componentVersionURL, ComponentVersionView.class);
            final String vulnURL = metaService.getFirstLink(componentVersion, MetaService.VULNERABILITIES_LINK);
            final List<VulnerabilityView> vulnItems = vulnerabilityRequestService.getComponentVersionVulnerabilities(vulnURL);
            return vulnItems;

        }
        throw new HubIntegrationException("Could not find version " + version + " of component " + StringUtils.join(new String[] { groupId, artifactId, version }, ":"));
    }

}
