/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.report.pdf.util;

import com.blackducksoftware.integration.hub.report.pdf.StringManager;
import com.blackducksoftware.integration.log.IntLogger;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;

public class PDFBoxManager
implements Closeable {
    private final IntLogger logger;
    public final File outputFile;
    public final PDDocument document;
    public PDPage currentPage;
    private PDPageContentStream contentStream;
    public static final PDFont DEFAULT_FONT = PDType1Font.HELVETICA;
    public static final PDFont DEFAULT_FONT_BOLD = PDType1Font.HELVETICA_BOLD;
    public static final float DEFAULT_FONT_SIZE = 10.0f;
    public static final Color DEFAULT_COLOR = Color.BLACK;

    public PDFBoxManager(IntLogger logger, File outputFile, PDDocument document) throws IOException {
        this.logger = logger;
        this.outputFile = outputFile;
        this.document = document;
        document.getDocumentInformation().setAuthor("Black Duck Software");
        document.getDocumentInformation().setCreator("Integrations");
        document.getDocumentInformation().setSubject("Hub Risk Report");
        this.currentPage = new PDPage();
        document.addPage(this.currentPage);
        this.contentStream = new PDPageContentStream(document, this.currentPage, PDPageContentStream.AppendMode.APPEND, true, false);
    }

    public PDRectangle drawRectangleCentered(float x, float cellUpperY, float width, float height, float cellHeight, Color color) throws IOException {
        return this.drawRectangle(x - width / 2.0f, cellUpperY - cellHeight / 2.0f - height / 2.0f, width, height, color);
    }

    public PDRectangle drawRectangle(float x, float y, float width, float height, Color color) throws IOException {
        float startingY = this.checkYAndSwitchPage(y, height);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.addRect(x, startingY, width, height);
        this.contentStream.fill();
        return new PDRectangle(x, startingY, width, height);
    }

    public PDRectangle drawImageCentered(float x, float cellUpperY, float width, float height, float cellWidth, float cellHeight, String resourceImageName) throws IOException, URISyntaxException {
        return this.drawImage(x - cellWidth / 2.0f, cellUpperY - cellHeight / 2.0f - height / 2.0f, width, height, resourceImageName);
    }

    public PDRectangle drawImage(float x, float y, float width, float height, String resourceImageName) throws IOException, URISyntaxException {
        float startingY = this.checkYAndSwitchPage(y, height);
        BufferedImage bufferedImage = ImageIO.read(this.getClass().getResourceAsStream(resourceImageName));
        PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)this.document, (BufferedImage)bufferedImage);
        this.contentStream.drawImage(pdImage, x, startingY, width, height);
        return new PDRectangle(x, startingY, width, height);
    }

    public PDRectangle writeTextCentered(float x, float y, String text, PDFont font, float fontSize, Color textColor) throws IOException {
        float textLength = StringManager.getStringWidth(font, fontSize, text);
        return this.writeText(x - textLength / 2.0f, y, text, font, fontSize, textColor);
    }

    public PDRectangle writeTextCentered(float x, float y, String text) throws IOException {
        return this.writeTextCentered(x, y, text, DEFAULT_FONT, 10.0f, DEFAULT_COLOR);
    }

    public PDRectangle writeTextCentered(float x, float cellUpperY, float height, String text, PDFont font, float fontSize, Color textColor) throws IOException {
        float textLength = StringManager.getStringWidth(font, fontSize, text);
        return this.writeText(x - textLength / 2.0f, cellUpperY - height / 2.0f - fontSize / 2.0f, text, font, fontSize, textColor);
    }

    public PDRectangle writeTextCentered(float x, float y, float height, String text) throws IOException {
        return this.writeTextCentered(x, y, height, text, DEFAULT_FONT, 10.0f, DEFAULT_COLOR);
    }

    public PDRectangle writeText(float x, float y, String text) throws IOException {
        return this.writeText(x, y, text, DEFAULT_FONT, 10.0f, DEFAULT_COLOR);
    }

    public PDRectangle writeText(float x, float y, String text, PDFont font, float fontSize, Color textColor) throws IOException {
        float startingY = this.checkYAndSwitchPage(y, fontSize);
        this.contentStream.beginText();
        this.contentStream.setFont(font, fontSize);
        this.contentStream.setNonStrokingColor(textColor);
        this.contentStream.newLineAtOffset(x, startingY);
        this.contentStream.showText(text);
        this.contentStream.endText();
        return new PDRectangle(x, startingY, StringManager.getStringWidth(font, fontSize, text), fontSize);
    }

    public PDRectangle writeWrappedText(float x, float y, float width, String text) throws IOException {
        return this.writeWrappedText(x, y, width, text, DEFAULT_FONT, 10.0f, DEFAULT_COLOR);
    }

    public PDRectangle writeWrappedCenteredText(float x, float cellUpperY, float width, float height, List<String> textLines, PDFont font, float fontSize, Color color) throws IOException {
        float lowestY = this.checkYAndSwitchPage(cellUpperY - height, fontSize);
        int numOfLines = textLines.size();
        int centerOfText = numOfLines / 2;
        float actualWidth = width;
        float leftMostX = x + width;
        float centerY = cellUpperY - height / 2.0f - fontSize / 2.0f;
        if (numOfLines % 2 == 0) {
            centerY -= fontSize / 2.0f;
        }
        for (int i = 0; i < numOfLines; ++i) {
            float textLength = StringManager.getStringWidth(font, fontSize, textLines.get(i));
            float textX = x - textLength / 2.0f;
            if (textX < leftMostX) {
                leftMostX = textX;
            }
            float textY = 0.0f;
            int difference = Math.abs(i - centerOfText);
            textY = i < centerOfText ? centerY + (float)difference * fontSize : centerY - (float)difference * fontSize;
            PDRectangle rectangle = this.writeText(textX, textY, textLines.get(i), font, fontSize, color);
            if (numOfLines != 1) continue;
            actualWidth = rectangle.getWidth();
        }
        return new PDRectangle(leftMostX, lowestY, actualWidth, height);
    }

    public PDRectangle writeWrappedVerticalCenteredText(float x, float cellUpperY, float width, float height, List<String> textLines) throws IOException {
        return this.writeWrappedVerticalCenteredText(x, cellUpperY, width, height, textLines, DEFAULT_FONT, 10.0f, DEFAULT_COLOR);
    }

    public PDRectangle writeWrappedVerticalCenteredText(float x, float cellUpperY, float width, float height, List<String> textLines, PDFont font, float fontSize, Color color) throws IOException {
        float lowestY = this.checkYAndSwitchPage(cellUpperY - height, fontSize);
        int numOfLines = textLines.size();
        int centerOfText = numOfLines / 2;
        float actualWidth = width;
        float centerY = cellUpperY - height / 2.0f - fontSize / 3.0f;
        if (numOfLines % 2 == 0) {
            centerY -= fontSize / 2.0f;
        }
        for (int i = 0; i < numOfLines; ++i) {
            float textY = 0.0f;
            int difference = Math.abs(i - centerOfText);
            textY = i < centerOfText ? centerY + (float)difference * fontSize : centerY - (float)difference * fontSize;
            PDRectangle rectangle = this.writeText(x, textY, textLines.get(i), font, fontSize, color);
            if (numOfLines != 1) continue;
            actualWidth = rectangle.getWidth();
        }
        return new PDRectangle(x, lowestY, actualWidth, height);
    }

    public PDRectangle writeWrappedText(float x, float y, float width, String text, PDFont font, float fontSize, Color color) throws IOException {
        List<String> textLines = StringManager.wrapToCombinedList(font, fontSize, text, Math.round(width));
        return this.writeWrappedText(x, y, width, textLines, font, fontSize, color);
    }

    public PDRectangle writeWrappedText(float x, float y, float width, List<String> textLines) throws IOException {
        return this.writeWrappedText(x, y, width, textLines, DEFAULT_FONT, 10.0f, DEFAULT_COLOR);
    }

    public PDRectangle writeWrappedText(float x, float y, float width, List<String> textLines, PDFont font, float fontSize, Color color) throws IOException {
        float startingY = this.checkYAndSwitchPage(y, fontSize);
        int numOfLines = textLines.size();
        float actualWidth = width;
        float approximateHeight = 0.0f;
        float lowestY = startingY;
        for (int i = 0; i < numOfLines; ++i) {
            float textY = startingY - (float)i * fontSize;
            if (textY < lowestY) {
                lowestY = textY;
            }
            PDRectangle rectangle = this.writeText(x, textY, textLines.get(i), font, fontSize, color);
            if (numOfLines == 1) {
                actualWidth = rectangle.getWidth();
            }
            approximateHeight += rectangle.getHeight();
        }
        return new PDRectangle(x, lowestY, actualWidth, approximateHeight);
    }

    public PDRectangle writeLink(float x, float y, String linkText, String linkURL, PDFont font, float fontSize) throws IOException {
        PDRectangle rectangle = this.writeText(x, y, linkText, font, fontSize, Color.decode("#46759E"));
        this.addAnnotationLinkRectangle(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight(), linkURL);
        return rectangle;
    }

    public PDRectangle writeWrappedLink(float x, float y, float width, String linkText, String linkURL, PDFont font, float fontSize) throws IOException {
        return this.writeWrappedLink(x, y, width, linkText, linkURL, font, fontSize, Color.decode("#46759E"));
    }

    public PDRectangle writeWrappedLink(float x, float y, float width, String linkText, String linkURL, PDFont font, float fontSize, Color color) throws IOException {
        PDRectangle rectangle = this.writeWrappedText(x, y, width, linkText, font, fontSize, color);
        this.addAnnotationLinkRectangle(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight(), linkURL);
        return rectangle;
    }

    public PDRectangle writeWrappedVerticalCenteredLink(float x, float cellUpperY, float width, float height, List<String> linkTextLines, String linkURL, Color color) throws IOException {
        return this.writeWrappedVerticalCenteredLink(x, cellUpperY, width, height, linkTextLines, linkURL, DEFAULT_FONT, 10.0f, color);
    }

    public PDRectangle writeWrappedVerticalCenteredLink(float x, float cellUpperY, float width, float height, List<String> linkTextLines, String linkURL, PDFont font, float fontSize, Color color) throws IOException {
        PDRectangle rectangle = this.writeWrappedVerticalCenteredText(x, cellUpperY, width, height, linkTextLines, font, fontSize, color);
        this.addAnnotationLinkRectangle(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight(), linkURL);
        return rectangle;
    }

    public PDRectangle writeWrappedLink(float x, float y, float width, List<String> linkTextLines, String linkURL, PDFont font, float fontSize) throws IOException {
        return this.writeWrappedLink(x, y, width, linkTextLines, linkURL, font, fontSize, Color.decode("#46759E"));
    }

    public PDRectangle writeWrappedCenteredLink(float x, float rowUpperY, float width, float height, List<String> linkTextLines, String linkURL, Color color) throws IOException {
        return this.writeWrappedCenteredLink(x, rowUpperY, width, height, linkTextLines, linkURL, DEFAULT_FONT, 10.0f, color);
    }

    public PDRectangle writeWrappedCenteredLink(float x, float rowUpperY, float width, float height, List<String> linkTextLines, String linkURL, PDFont font, float fontSize, Color color) throws IOException {
        PDRectangle rectangle = this.writeWrappedCenteredText(x, rowUpperY, width, height, linkTextLines, font, fontSize, color);
        this.addAnnotationLinkRectangle(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight(), linkURL);
        return rectangle;
    }

    public PDRectangle writeWrappedLink(float x, float y, float width, List<String> linkTextLines, String linkURL, Color color) throws IOException {
        return this.writeWrappedLink(x, y, width, linkTextLines, linkURL, DEFAULT_FONT, 10.0f, color);
    }

    public PDRectangle writeWrappedLink(float x, float y, float width, List<String> linkTextLines, String linkURL, PDFont font, float fontSize, Color color) throws IOException {
        PDRectangle rectangle = this.writeWrappedText(x, y, width, linkTextLines, font, fontSize, color);
        this.addAnnotationLinkRectangle(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight(), linkURL);
        return rectangle;
    }

    private PDRectangle addAnnotationLinkRectangle(float x, float y, float width, float height, String linkURL) throws IOException {
        float startingY = this.checkYAndSwitchPage(y, height);
        PDAnnotationLink txtLink = new PDAnnotationLink();
        PDRectangle position = new PDRectangle();
        position.setLowerLeftX(x);
        position.setLowerLeftY(startingY);
        position.setUpperRightX(x + width);
        position.setUpperRightY(startingY + height);
        txtLink.setRectangle(position);
        PDActionURI action = new PDActionURI();
        action.setURI(linkURL);
        txtLink.setAction((PDAction)action);
        this.currentPage.getAnnotations().add(txtLink);
        return new PDRectangle(x, startingY, width, height);
    }

    private float checkYAndSwitchPage(float y, float height) throws IOException {
        if (y - 20.0f < 0.0f) {
            this.contentStream.close();
            this.currentPage = new PDPage();
            this.document.addPage(this.currentPage);
            this.contentStream = new PDPageContentStream(this.document, this.currentPage, PDPageContentStream.AppendMode.APPEND, true, false);
            return this.currentPage.getMediaBox().getHeight() - 20.0f - height;
        }
        return y;
    }

    public float getApproximateWrappedStringHeight(int numberOfTextLines, float fontSize) {
        return (float)numberOfTextLines * fontSize + fontSize;
    }

    @Override
    public void close() throws IOException {
        this.contentStream.close();
        this.document.save(this.outputFile);
        this.document.close();
    }
}

