/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.utils;

import com.bettercloud.scim2.common.utils.ScimDateFormat;
import com.bettercloud.scim2.common.utils.ScimJsonFactory;
import com.bettercloud.scim2.common.utils.ScimJsonNodeFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Map;

public class MapperFactory {
    private static Map<DeserializationFeature, Boolean> deserializationCustomFeatures = Collections.emptyMap();
    private static Map<JsonParser.Feature, Boolean> jsonParserCustomFeatures = Collections.emptyMap();
    private static Map<JsonGenerator.Feature, Boolean> jsonGeneratorCustomFeatures = Collections.emptyMap();
    private static Map<MapperFeature, Boolean> mapperCustomFeatures = Collections.emptyMap();
    private static Map<SerializationFeature, Boolean> serializationCustomFeatures = Collections.emptyMap();

    public MapperFactory setDeserializationCustomFeatures(Map<DeserializationFeature, Boolean> customFeatures) {
        deserializationCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setJsonGeneratorCustomFeatures(Map<JsonGenerator.Feature, Boolean> customFeatures) {
        jsonGeneratorCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setJsonParserCustomFeatures(Map<JsonParser.Feature, Boolean> customFeatures) {
        jsonParserCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setMapperCustomFeatures(Map<MapperFeature, Boolean> customFeatures) {
        mapperCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setSerializationCustomFeatures(Map<SerializationFeature, Boolean> customFeatures) {
        serializationCustomFeatures = customFeatures;
        return this;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new ScimJsonFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDateFormat((DateFormat)((Object)new ScimDateFormat()));
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        mapper.setNodeFactory((JsonNodeFactory)new ScimJsonNodeFactory());
        for (DeserializationFeature deserializationFeature : deserializationCustomFeatures.keySet()) {
            mapper.configure(deserializationFeature, deserializationCustomFeatures.get(deserializationFeature).booleanValue());
        }
        for (JsonGenerator.Feature feature : jsonGeneratorCustomFeatures.keySet()) {
            mapper.configure(feature, jsonGeneratorCustomFeatures.get(feature).booleanValue());
        }
        for (JsonParser.Feature feature : jsonParserCustomFeatures.keySet()) {
            mapper.configure(feature, jsonParserCustomFeatures.get(feature).booleanValue());
        }
        for (MapperFeature mapperFeature : mapperCustomFeatures.keySet()) {
            mapper.configure(mapperFeature, mapperCustomFeatures.get(mapperFeature).booleanValue());
        }
        for (SerializationFeature serializationFeature : serializationCustomFeatures.keySet()) {
            mapper.configure(serializationFeature, serializationCustomFeatures.get(serializationFeature).booleanValue());
        }
        return mapper;
    }
}

