/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.utils;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.filters.Filter;
import com.bettercloud.scim2.common.messages.PatchOperation;
import com.bettercloud.scim2.common.utils.Debug;
import com.bettercloud.scim2.common.utils.DebugType;
import com.bettercloud.scim2.common.utils.JsonUtils;
import com.bettercloud.scim2.common.utils.SchemaUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class JsonDiff {
    public List<PatchOperation> diff(ObjectNode source, ObjectNode target, boolean removeMissing) {
        LinkedList<PatchOperation> ops = new LinkedList<PatchOperation>();
        ObjectNode targetToAdd = target.deepCopy();
        ObjectNode targetToReplace = target.deepCopy();
        this.diff(Path.root(), source, targetToAdd, targetToReplace, ops, removeMissing);
        if (targetToReplace.size() > 0) {
            ops.add(PatchOperation.replace(targetToReplace));
        }
        if (targetToAdd.size() > 0) {
            ops.add(PatchOperation.add((JsonNode)targetToAdd));
        }
        return ops;
    }

    private void diff(Path parentPath, ObjectNode source, ObjectNode targetToAdd, ObjectNode targetToReplace, List<PatchOperation> operations, boolean removeMissing) {
        Iterator si = source.fields();
        while (si.hasNext()) {
            this.processEntry(parentPath, targetToAdd, targetToReplace, operations, removeMissing, (Map.Entry)si.next());
        }
        if (targetToAdd != targetToReplace) {
            Iterator ai = targetToAdd.fieldNames();
            while (ai.hasNext()) {
                String f = (String)ai.next();
                if (source.has(f)) continue;
                ai.remove();
            }
        }
        this.removeNullAndEmptyValues((JsonNode)targetToAdd);
        this.removeNullAndEmptyValues((JsonNode)targetToReplace);
    }

    private void processEntry(Path parentPath, ObjectNode targetToAdd, ObjectNode targetToReplace, List<PatchOperation> operations, boolean removeMissing, Map.Entry<String, JsonNode> sourceEntry) {
        JsonNode targetValueToReplace;
        String sourceKey = sourceEntry.getKey();
        JsonNode sourceNode = sourceEntry.getValue();
        Path path = this.computeDiffPath(parentPath, sourceKey, sourceNode);
        JsonNode targetValueToAdd = targetToAdd.remove(sourceKey);
        JsonNode jsonNode = targetValueToReplace = targetToReplace == targetToAdd ? targetValueToAdd : targetToReplace.remove(sourceKey);
        if (targetValueToAdd == null) {
            if (removeMissing) {
                operations.add(PatchOperation.remove(path));
            }
            return;
        }
        if (this.isSameType(sourceNode, targetValueToAdd)) {
            this.replaceNode(parentPath, path, targetToAdd, targetToReplace, operations, removeMissing, sourceNode, targetValueToAdd, targetValueToReplace, sourceKey);
        } else if (targetValueToAdd.isNull() || targetValueToAdd.isArray() && targetValueToAdd.size() == 0) {
            operations.add(PatchOperation.remove(path));
        } else {
            targetToReplace.set(sourceKey, targetValueToReplace);
        }
    }

    private void replaceNode(Path parentPath, Path path, ObjectNode targetToAdd, ObjectNode targetToReplace, List<PatchOperation> operations, boolean removeMissing, JsonNode sourceNode, JsonNode targetValueToAdd, JsonNode targetValueToReplace, String sourceKey) {
        if (sourceNode.isObject()) {
            this.computeObjectNodeDiffs(path, sourceNode, targetValueToAdd, targetValueToReplace, operations, removeMissing, targetToAdd, targetToReplace, sourceKey);
        } else if (sourceNode.isArray()) {
            this.computeArrayNodeDiffs(parentPath, path, targetToAdd, targetToReplace, operations, removeMissing, sourceNode, targetValueToAdd, targetValueToReplace, sourceKey);
        } else if (this.compareTo(path.withoutFilters(), sourceNode, targetValueToAdd) != 0) {
            targetToReplace.set(sourceKey, targetValueToReplace);
        }
    }

    protected int compareTo(Path path, JsonNode sourceNode, JsonNode targetNode) {
        return JsonUtils.compareTo(sourceNode, targetNode, null);
    }

    private void computeArrayNodeDiffs(Path parentPath, Path path, ObjectNode targetToAdd, ObjectNode targetToReplace, List<PatchOperation> operations, boolean removeMissing, JsonNode sourceNode, JsonNode targetValueToAdd, JsonNode targetValueToReplace, String sourceKey) {
        if (targetValueToAdd.size() == 0) {
            if (sourceNode != null && sourceNode.isArray() && sourceNode.size() == 0) {
                return;
            }
            operations.add(PatchOperation.remove(path));
        } else {
            LinkedList<PatchOperation> targetOpToRemoveOrReplace = new LinkedList<PatchOperation>();
            boolean replaceAllValues = false;
            for (JsonNode sv : sourceNode) {
                JsonNode tv = this.removeMatchingValue(sv, (ArrayNode)targetValueToAdd);
                Filter valueFilter = this.generateValueFilter(sv);
                if (valueFilter == null) {
                    replaceAllValues = true;
                    Debug.debug(Level.WARNING, DebugType.OTHER, "Performing full replace of target array node " + path + " since the it is not possible to generate a value filter to uniquely identify the value " + sv.toString());
                    break;
                }
                Path valuePath = parentPath.attribute(sourceKey, valueFilter);
                if (tv != null) {
                    if (!sv.isObject() || !tv.isObject()) continue;
                    this.diff(valuePath, (ObjectNode)sv, (ObjectNode)tv, (ObjectNode)tv, operations, removeMissing);
                    if (tv.size() <= 0) continue;
                    targetOpToRemoveOrReplace.add(PatchOperation.replace(valuePath, tv));
                    continue;
                }
                targetOpToRemoveOrReplace.add(PatchOperation.remove(valuePath));
            }
            if (!replaceAllValues && targetValueToReplace.size() <= targetValueToAdd.size() + targetOpToRemoveOrReplace.size()) {
                Debug.debug(Level.INFO, DebugType.OTHER, "Performing full replace of target array node " + path + " since the array (" + targetValueToReplace.size() + ") is smaller than removing and replacing (" + targetOpToRemoveOrReplace.size() + ") then adding (" + targetValueToAdd.size() + ")  the values individually");
                replaceAllValues = true;
                targetToReplace.set(sourceKey, targetValueToReplace);
            }
            if (replaceAllValues) {
                targetToReplace.set(sourceKey, targetValueToReplace);
            } else {
                if (!targetOpToRemoveOrReplace.isEmpty()) {
                    operations.addAll(targetOpToRemoveOrReplace);
                }
                if (targetValueToAdd.size() > 0) {
                    targetToAdd.set(sourceKey, targetValueToAdd);
                }
            }
        }
    }

    private void computeObjectNodeDiffs(Path path, JsonNode sourceNode, JsonNode targetValueToAdd, JsonNode targetValueToReplace, List<PatchOperation> operations, boolean removeMissing, ObjectNode targetToAdd, ObjectNode targetToReplace, String sourceKey) {
        this.diff(path, (ObjectNode)sourceNode, (ObjectNode)targetValueToAdd, (ObjectNode)targetValueToReplace, operations, removeMissing);
        if (targetValueToAdd.size() > 0) {
            targetToAdd.set(sourceKey, targetValueToAdd);
        }
        if (targetValueToReplace.size() > 0) {
            targetToReplace.set(sourceKey, targetValueToReplace);
        }
    }

    private Path computeDiffPath(Path parentPath, String sourceKey, JsonNode sourceNode) {
        return parentPath.isRoot() && SchemaUtils.isUrn(sourceKey) ? Path.root(sourceKey) : parentPath.attribute(sourceKey);
    }

    private JsonNode removeMatchingValue(JsonNode sourceValue, ArrayNode targetValues) {
        if (sourceValue.isObject()) {
            TreeMap<Integer, Integer> matchScoreToIndex = new TreeMap<Integer, Integer>();
            for (int i = 0; i < targetValues.size(); ++i) {
                JsonNode targetValue = targetValues.get(i);
                if (!targetValue.isObject()) continue;
                int matchScore = 0;
                Iterator si = sourceValue.fieldNames();
                while (si.hasNext()) {
                    String field = (String)si.next();
                    if (!sourceValue.get(field).equals((Object)targetValue.path(field))) continue;
                    if (field.equals("value") || field.equals("$ref")) {
                        matchScore += 3;
                        continue;
                    }
                    if (field.equals("type") || field.equals("display")) {
                        matchScore += 2;
                        continue;
                    }
                    if (field.equals("primary")) {
                        matchScore += 0;
                        continue;
                    }
                    ++matchScore;
                }
                if (matchScore <= 0 || matchScoreToIndex.containsKey(matchScore)) continue;
                matchScoreToIndex.put(matchScore, i);
            }
            if (!matchScoreToIndex.isEmpty()) {
                return targetValues.remove(((Integer)matchScoreToIndex.lastEntry().getValue()).intValue());
            }
        } else {
            for (int i = 0; i < targetValues.size(); ++i) {
                if (JsonUtils.compareTo(sourceValue, targetValues.get(i), null) != 0) continue;
                return targetValues.remove(i);
            }
        }
        return null;
    }

    private Filter generateValueFilter(JsonNode value) {
        if (value.isValueNode()) {
            return Filter.eq(Path.root().attribute("value"), (ValueNode)value);
        }
        if (value.isObject()) {
            ArrayList<Filter> filters = new ArrayList<Filter>(value.size());
            Iterator fieldsIterator = value.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                if (!((JsonNode)field.getValue()).isValueNode()) {
                    return null;
                }
                filters.add(Filter.eq(Path.root().attribute((String)field.getKey()), (ValueNode)field.getValue()));
            }
            if (filters.size() == 0) {
                return null;
            }
            if (filters.size() == 1) {
                return (Filter)filters.get(0);
            }
            return Filter.and(filters);
        }
        return null;
    }

    private void removeNullAndEmptyValues(JsonNode node) {
        Iterator si = node.elements();
        while (si.hasNext()) {
            JsonNode field = (JsonNode)si.next();
            if (field.isNull() || field.isArray() && field.size() == 0) {
                si.remove();
                continue;
            }
            if (!field.isContainerNode()) continue;
            this.removeNullAndEmptyValues(field);
        }
    }

    public boolean isSameType(JsonNode n1, JsonNode n2) {
        return n1.getNodeType() == n2.getNodeType() || (n1.isTextual() || n1.isBinary()) && (n2.isTextual() || n2.isBinary());
    }
}

