/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.utils;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.exceptions.BadRequestException;
import com.bettercloud.scim2.common.exceptions.ScimException;
import com.bettercloud.scim2.common.filters.AndFilter;
import com.bettercloud.scim2.common.filters.ComplexValueFilter;
import com.bettercloud.scim2.common.filters.ContainsFilter;
import com.bettercloud.scim2.common.filters.EndsWithFilter;
import com.bettercloud.scim2.common.filters.EqualFilter;
import com.bettercloud.scim2.common.filters.Filter;
import com.bettercloud.scim2.common.filters.FilterVisitor;
import com.bettercloud.scim2.common.filters.GreaterThanFilter;
import com.bettercloud.scim2.common.filters.GreaterThanOrEqualFilter;
import com.bettercloud.scim2.common.filters.LessThanFilter;
import com.bettercloud.scim2.common.filters.LessThanOrEqualFilter;
import com.bettercloud.scim2.common.filters.NotEqualFilter;
import com.bettercloud.scim2.common.filters.NotFilter;
import com.bettercloud.scim2.common.filters.OrFilter;
import com.bettercloud.scim2.common.filters.PresentFilter;
import com.bettercloud.scim2.common.filters.StartsWithFilter;
import com.bettercloud.scim2.common.types.AttributeDefinition;
import com.bettercloud.scim2.common.utils.JsonUtils;
import com.bettercloud.scim2.common.utils.StaticUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FilterEvaluator
implements FilterVisitor<Boolean, JsonNode> {
    private static final FilterEvaluator SINGLETON = new FilterEvaluator();
    private static final Path VALUE_PATH = Path.root().attribute("value");

    public static boolean evaluate(Filter filter, JsonNode jsonNode) throws ScimException {
        return filter.visit(SINGLETON, jsonNode);
    }

    @Override
    public Boolean visit(EqualFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        if (filter.getComparisonValue().isNull() && this.isEmpty(nodes)) {
            return true;
        }
        for (JsonNode node : nodes) {
            if (JsonUtils.compareTo(node, (JsonNode)filter.getComparisonValue(), this.getAttributeDefinition(filter.getAttributePath())) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(NotEqualFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        if (filter.getComparisonValue().isNull() && this.isEmpty(nodes)) {
            return false;
        }
        for (JsonNode node : nodes) {
            if (JsonUtils.compareTo(node, (JsonNode)filter.getComparisonValue(), this.getAttributeDefinition(filter.getAttributePath())) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ContainsFilter filter, JsonNode object) throws ScimException {
        return this.substringMatch(filter, object);
    }

    @Override
    public Boolean visit(StartsWithFilter filter, JsonNode object) throws ScimException {
        return this.substringMatch(filter, object);
    }

    @Override
    public Boolean visit(EndsWithFilter filter, JsonNode object) throws ScimException {
        return this.substringMatch(filter, object);
    }

    @Override
    public Boolean visit(PresentFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (this.isEmpty(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(GreaterThanFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (node.isBoolean() || node.isBinary()) {
                throw BadRequestException.invalidFilter("Greater than filter may not compare boolean or binary attribute values");
            }
            if (JsonUtils.compareTo(node, (JsonNode)filter.getComparisonValue(), this.getAttributeDefinition(filter.getAttributePath())) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(GreaterThanOrEqualFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (node.isBoolean() || node.isBinary()) {
                throw BadRequestException.invalidFilter("Greater than or equal filter may not compare boolean or binary attribute values");
            }
            if (JsonUtils.compareTo(node, (JsonNode)filter.getComparisonValue(), this.getAttributeDefinition(filter.getAttributePath())) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(LessThanFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (node.isBoolean() || node.isBinary()) {
                throw BadRequestException.invalidFilter("Less than or equal filter may not compare boolean or binary attribute values");
            }
            if (JsonUtils.compareTo(node, (JsonNode)filter.getComparisonValue(), this.getAttributeDefinition(filter.getAttributePath())) >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(LessThanOrEqualFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (node.isBoolean() || node.isBinary()) {
                throw BadRequestException.invalidFilter("Less than or equal filter may not compare boolean or binary attribute values");
            }
            if (JsonUtils.compareTo(node, (JsonNode)filter.getComparisonValue(), this.getAttributeDefinition(filter.getAttributePath())) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(AndFilter filter, JsonNode object) throws ScimException {
        for (Filter combinedFilter : filter.getCombinedFilters()) {
            if (combinedFilter.visit(this, object).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(OrFilter filter, JsonNode object) throws ScimException {
        for (Filter combinedFilter : filter.getCombinedFilters()) {
            if (!combinedFilter.visit(this, object).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(NotFilter filter, JsonNode object) throws ScimException {
        return filter.getInvertedFilter().visit(this, object) == false;
    }

    @Override
    public Boolean visit(ComplexValueFilter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (node.isArray()) {
                for (JsonNode value : node) {
                    if (!filter.getValueFilter().visit(this, value).booleanValue()) continue;
                    return true;
                }
                continue;
            }
            if (!filter.getValueFilter().visit(this, node).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected AttributeDefinition getAttributeDefinition(Path path) {
        return null;
    }

    private Iterable<JsonNode> getCandidateNodes(Path path, JsonNode jsonNode) throws ScimException {
        if (jsonNode.isArray()) {
            return jsonNode;
        }
        if (jsonNode.isObject()) {
            List<JsonNode> nodes = JsonUtils.findMatchingPaths(path, (ObjectNode)jsonNode);
            ArrayList<JsonNode> flattenedNodes = new ArrayList<JsonNode>(nodes.size());
            for (JsonNode node : nodes) {
                if (node.isArray()) {
                    for (JsonNode child : node) {
                        flattenedNodes.add(child);
                    }
                    continue;
                }
                flattenedNodes.add(node);
            }
            return flattenedNodes;
        }
        if (jsonNode.isValueNode() && path.equals(VALUE_PATH)) {
            return Collections.singletonList(jsonNode);
        }
        return Collections.emptyList();
    }

    private boolean isEmpty(JsonNode node) {
        if (node.isArray()) {
            Iterator iterator = node.elements();
            while (iterator.hasNext()) {
                if (this.isEmpty((JsonNode)iterator.next())) continue;
                return false;
            }
            return true;
        }
        return node.isNull();
    }

    private boolean isEmpty(Iterable<JsonNode> nodes) {
        for (JsonNode node : nodes) {
            if (this.isEmpty(node)) continue;
            return false;
        }
        return true;
    }

    private boolean substringMatch(Filter filter, JsonNode object) throws ScimException {
        Iterable<JsonNode> nodes = this.getCandidateNodes(filter.getAttributePath(), object);
        for (JsonNode node : nodes) {
            if (node.isTextual() && filter.getComparisonValue().isTextual()) {
                AttributeDefinition attributeDefinition = this.getAttributeDefinition(filter.getAttributePath());
                String nodeValue = node.textValue();
                String comparisonValue = filter.getComparisonValue().textValue();
                if (attributeDefinition == null || !attributeDefinition.isCaseExact()) {
                    nodeValue = StaticUtils.toLowerCase(nodeValue);
                    comparisonValue = StaticUtils.toLowerCase(comparisonValue);
                }
                switch (filter.getFilterType()) {
                    case CONTAINS: {
                        if (!nodeValue.contains(comparisonValue)) break;
                        return true;
                    }
                    case STARTS_WITH: {
                        if (!nodeValue.startsWith(comparisonValue)) break;
                        return true;
                    }
                    case ENDS_WITH: {
                        if (!nodeValue.endsWith(comparisonValue)) break;
                        return true;
                    }
                }
                continue;
            }
            if (!node.equals((Object)filter.getComparisonValue())) continue;
            return true;
        }
        return false;
    }
}

