/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.types;

import com.bettercloud.scim2.common.annotations.Attribute;
import com.bettercloud.scim2.common.types.AttributeDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.net.URISyntaxException;

public class AuthenticationScheme {
    @Attribute(description="The common authentication scheme name; e.g., HTTP Basic.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final String name;
    @Attribute(description="A description of the Authentication Scheme.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final String description;
    @Attribute(description="An HTTP addressable URI pointing to the Authentication Scheme's specification.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private final URI specUri;
    @Attribute(description="An HTTP addressable URI pointing to the Authentication Scheme's usage documentation.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private final URI documentationUri;
    @Attribute(description="A label indicating the authentication scheme type; e.g., \"oauth\" or \"oauth2\".", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true, canonicalValues={"oauth", "oauth2", "oauthbearertoken", "httpbasic", "httpdigest"})
    private final String type;
    @Attribute(description="A Boolean value indicating whether this authentication scheme is preferred.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final boolean primary;

    public AuthenticationScheme(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="specUri") URI specUri, @JsonProperty(value="documentationUri") URI documentationUri, @JsonProperty(value="type") String type, @JsonProperty(value="primary", defaultValue="false") boolean primary) {
        this.name = name;
        this.description = description;
        this.specUri = specUri;
        this.documentationUri = documentationUri;
        this.type = type;
        this.primary = primary;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getSpecUri() {
        return this.specUri;
    }

    public URI getDocumentationUri() {
        return this.documentationUri;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationScheme that = (AuthenticationScheme)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.documentationUri != null ? !this.documentationUri.equals(that.documentationUri) : that.documentationUri != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.specUri != null ? !this.specUri.equals(that.specUri) : that.specUri != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.specUri != null ? this.specUri.hashCode() : 0);
        result = 31 * result + (this.documentationUri != null ? this.documentationUri.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        return result;
    }

    public static AuthenticationScheme createHttpBasic(boolean primary) {
        try {
            return new AuthenticationScheme("HTTP Basic", "The HTTP Basic Access Authentication scheme. This scheme is not considered to be a secure method of user authentication (unless used in conjunction with some external secure system such as SSL), as the user name and password are passed over the network as cleartext.", new URI("http://www.ietf.org/rfc/rfc2617.txt"), null, "httpbasic", primary);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static AuthenticationScheme createOAuth2BearerToken(boolean primary) {
        try {
            return new AuthenticationScheme("OAuth 2.0 Bearer Token", "The OAuth 2.0 Bearer Token Authentication scheme. OAuth enables clients to access protected resources by obtaining an access token, which is defined in RFC 6750 as \"a string representing an access authorization issued to the client\", rather than using the resource owner's credentials directly.", new URI("http://tools.ietf.org/html/rfc6750"), null, "oauthbearertoken", primary);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

