/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.messages;

import com.bettercloud.scim2.common.BaseScimResource;
import com.bettercloud.scim2.common.annotations.Attribute;
import com.bettercloud.scim2.common.annotations.Schema;
import com.bettercloud.scim2.common.types.AttributeDefinition;
import com.bettercloud.scim2.common.utils.StatusDeserializer;
import com.bettercloud.scim2.common.utils.StatusSerializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@Schema(id="urn:ietf:params:scim:api:messages:2.0:Error", name="Error Response", description="SCIM 2.0 Error Response")
public final class ErrorResponse
extends BaseScimResource {
    private static final long serialVersionUID = 7358025734457872228L;
    @Attribute(description="A SCIM detailed error keyword.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String scimType;
    @Attribute(description="A detailed, human readable message.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String detail;
    @Attribute(description="The HTTP status code.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    @JsonSerialize(using=StatusSerializer.class)
    @JsonDeserialize(using=StatusDeserializer.class)
    private final int status;

    @JsonCreator
    public ErrorResponse(@JsonProperty(value="status", required=true) int status) {
        this.status = status;
    }

    public String getScimType() {
        return this.scimType;
    }

    public void setScimType(String scimType) {
        this.scimType = scimType;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Integer getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)o;
        if (this.status != that.status) {
            return false;
        }
        if (this.detail != null ? !this.detail.equals(that.detail) : that.detail != null) {
            return false;
        }
        return !(this.scimType != null ? !this.scimType.equals(that.scimType) : that.scimType != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.scimType != null ? this.scimType.hashCode() : 0);
        result = 31 * result + (this.detail != null ? this.detail.hashCode() : 0);
        result = 31 * result + this.status;
        return result;
    }
}

