/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common;

import com.bettercloud.scim2.common.GenericScimResource;
import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.ScimResource;
import com.bettercloud.scim2.common.annotations.Schema;
import com.bettercloud.scim2.common.exceptions.BadRequestException;
import com.bettercloud.scim2.common.exceptions.ScimException;
import com.bettercloud.scim2.common.types.Meta;
import com.bettercloud.scim2.common.utils.JsonUtils;
import com.bettercloud.scim2.common.utils.SchemaUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonPropertyOrder(value={"schemas", "id", "externalId"})
public abstract class BaseScimResource
implements ScimResource,
Serializable {
    private static final long serialVersionUID = 7616682840981516746L;
    private String id;
    private String externalId;
    private Meta meta;
    @JsonProperty(value="schemas")
    private Set<String> schemaUrns = new HashSet<String>();
    private final ObjectNode extensionObjectNode = JsonUtils.getJsonNodeFactory().objectNode();

    public void prepareResource(URI serverContext) {
    }

    public BaseScimResource() {
        this(null);
    }

    public BaseScimResource(String id) {
        this.id = id;
        this.addMyUrn();
    }

    @JsonIgnore
    public ObjectNode getExtensionObjectNode() {
        return this.extensionObjectNode;
    }

    @Override
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Set<String> getSchemaUrns() {
        if (this.schemaUrns == null) {
            this.schemaUrns = new HashSet<String>();
        }
        return this.schemaUrns;
    }

    @Override
    public void setSchemaUrns(Collection<String> schemaUrns) {
        this.schemaUrns = new HashSet<String>(schemaUrns);
    }

    @JsonAnySetter
    protected void setAny(String key, JsonNode value) throws ScimException {
        if (SchemaUtils.isUrn(key) && value.isObject()) {
            this.extensionObjectNode.set(key, value);
        } else {
            Schema schemaAnnotation = this.getClass().getAnnotation(Schema.class);
            if (!schemaAnnotation.ignoreUnknown()) {
                String message = "Core attribute " + key + " is undefined";
                if (schemaAnnotation != null) {
                    message = message + " for schema " + schemaAnnotation.id();
                }
                throw BadRequestException.invalidSyntax(message);
            }
        }
    }

    @JsonAnyGetter
    protected Map<String, Object> getAny() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.extensionObjectNode.size());
        Iterator i = this.extensionObjectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            map.put((String)field.getKey(), field.getValue());
        }
        return map;
    }

    private void addMyUrn() {
        String mySchema = SchemaUtils.getSchemaUrn(this.getClass());
        if (mySchema != null && !mySchema.isEmpty()) {
            this.getSchemaUrns().add(mySchema);
        }
    }

    public List<JsonNode> getExtensionValues(String path) throws ScimException {
        return this.getExtensionValues(Path.fromString(path));
    }

    public List<JsonNode> getExtensionValues(Path path) throws ScimException {
        return JsonUtils.findMatchingPaths(path, this.extensionObjectNode);
    }

    public void replaceExtensionValue(String path, JsonNode value) throws ScimException {
        this.replaceExtensionValue(Path.fromString(path), value);
    }

    public void replaceExtensionValue(Path path, JsonNode value) throws ScimException {
        JsonUtils.replaceValue(path, this.extensionObjectNode, value);
    }

    @JsonIgnore
    public <T> T getExtension(Class<T> clazz) {
        try {
            JsonNode extensionNode = this.extensionObjectNode.path(this.getSchemaUrnOrThrowException(clazz));
            if (extensionNode.isMissingNode()) {
                return null;
            }
            return JsonUtils.nodeToValue(extensionNode, clazz);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JsonIgnore
    public <T> void setExtension(T extension) {
        String schemaUrn = this.getSchemaUrnOrThrowException(extension.getClass());
        this.extensionObjectNode.set(schemaUrn, JsonUtils.valueToNode(extension));
        this.schemaUrns.add(schemaUrn);
    }

    public <T> boolean removeExtension(Class<T> clazz) {
        String schemaUrn = this.getSchemaUrnOrThrowException(clazz);
        if (this.extensionObjectNode.remove(schemaUrn) == null) {
            return false;
        }
        this.schemaUrns.remove(schemaUrn);
        return true;
    }

    private <T> String getSchemaUrnOrThrowException(Class<T> clazz) {
        String schemaUrn = SchemaUtils.getSchemaUrn(clazz);
        if (schemaUrn == null) {
            throw new IllegalArgumentException("Unable to determine the extension class schema.");
        }
        return schemaUrn;
    }

    public void addExtensionValue(String path, ArrayNode values) throws ScimException {
        this.addExtensionValue(Path.fromString(path), values);
    }

    public void addExtensionValue(Path path, ArrayNode values) throws ScimException {
        JsonUtils.addValue(path, this.extensionObjectNode, (JsonNode)values);
    }

    public boolean removeExtensionValues(String path) throws ScimException {
        return this.removeExtensionValues(Path.fromString(path));
    }

    public boolean removeExtensionValues(Path path) throws ScimException {
        List<JsonNode> nodes = JsonUtils.removeValues(path, this.extensionObjectNode);
        return !nodes.isEmpty();
    }

    @Override
    public GenericScimResource asGenericScimResource() {
        ObjectNode object = (ObjectNode)JsonUtils.valueToNode(this);
        return new GenericScimResource(object);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseScimResource that = (BaseScimResource)o;
        if (this.extensionObjectNode != null ? !this.extensionObjectNode.equals((Object)that.extensionObjectNode) : that.extensionObjectNode != null) {
            return false;
        }
        if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.meta != null ? !this.meta.equals(that.meta) : that.meta != null) {
            return false;
        }
        return !(this.schemaUrns != null ? !this.schemaUrns.equals(that.schemaUrns) : that.schemaUrns != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
        result = 31 * result + (this.meta != null ? this.meta.hashCode() : 0);
        result = 31 * result + (this.schemaUrns != null ? this.schemaUrns.hashCode() : 0);
        result = 31 * result + (this.extensionObjectNode != null ? this.extensionObjectNode.hashCode() : 0);
        return result;
    }

    public String toString() {
        try {
            return JsonUtils.getObjectWriter().withDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

