/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber.types;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.internal.Util;
import com.beanit.asn1bean.ber.types.BerType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class BerReal
implements Serializable,
BerType {
    public static final BerTag tag = new BerTag(0, 0, 9);
    private static final long serialVersionUID = 1L;
    public double value;
    private byte[] code = null;

    public BerReal() {
    }

    public BerReal(byte[] code) {
        this.code = code;
    }

    public BerReal(double value) {
        this.value = value;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = this.encodeValue(reverseOS);
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    private int encodeValue(OutputStream reverseOS) throws IOException {
        int exponentFormat;
        long longBits = Double.doubleToLongBits(this.value);
        boolean isNegative = (longBits & Long.MIN_VALUE) == Long.MIN_VALUE;
        int exponent = (int)(longBits >> 52) & 0x7FF;
        long mantissa = longBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (exponent == 2047) {
            if (mantissa == 0x10000000000000L) {
                if (isNegative) {
                    reverseOS.write(65);
                } else {
                    reverseOS.write(64);
                }
                return 1;
            }
            throw new IOException("NAN not supported");
        }
        if (exponent == 0 && mantissa == 0x10000000000000L) {
            return 0;
        }
        exponent -= 1075;
        int exponentIncr = 0;
        while ((mantissa >> exponentIncr & 0xFFL) == 0L) {
            exponentIncr += 8;
        }
        while ((mantissa >> exponentIncr & 1L) == 0L) {
            ++exponentIncr;
        }
        exponent += exponentIncr;
        int mantissaLength = (64 - Long.numberOfLeadingZeros(mantissa >>= exponentIncr) + 7) / 8;
        for (int i = 0; i < mantissaLength; ++i) {
            reverseOS.write((int)(mantissa >> 8 * i));
        }
        int codeLength = mantissaLength;
        byte[] exponentBytes = BigInteger.valueOf(exponent).toByteArray();
        reverseOS.write(exponentBytes);
        codeLength += exponentBytes.length;
        if (exponentBytes.length < 4) {
            exponentFormat = exponentBytes.length - 1;
        } else {
            reverseOS.write(exponentBytes.length);
            ++codeLength;
            exponentFormat = 3;
        }
        if (isNegative) {
            reverseOS.write(0xC0 | exponentFormat);
        } else {
            reverseOS.write(0x80 | exponentFormat);
        }
        return ++codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int exponentLength;
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val == 0) {
            this.value = 0.0;
            return codeLength;
        }
        if (length.val == 1) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            if (nextByte == 64) {
                this.value = Double.POSITIVE_INFINITY;
            } else if (nextByte == 65) {
                this.value = Double.NEGATIVE_INFINITY;
            } else {
                throw new IOException("invalid real encoding");
            }
            return codeLength + 1;
        }
        byte[] byteCode = new byte[length.val];
        Util.readFully(is, byteCode);
        if ((byteCode[0] & 0x80) != 128) {
            throw new IOException("Only binary REAL encoding is supported");
        }
        codeLength += length.val;
        int tempLength = 1;
        int sign = 1;
        if ((byteCode[0] & 0x40) == 64) {
            sign = -1;
        }
        if ((exponentLength = (byteCode[0] & 3) + 1) == 4) {
            exponentLength = byteCode[1];
            ++tempLength;
        }
        tempLength += exponentLength;
        int exponent = 0;
        for (int i = 0; i < exponentLength; ++i) {
            exponent |= byteCode[1 + i] << 8 * (exponentLength - i - 1);
        }
        long mantissa = 0L;
        for (int i = 0; i < length.val - tempLength; ++i) {
            mantissa |= ((long)byteCode[i + tempLength] & 0xFFL) << 8 * (length.val - tempLength - i - 1);
        }
        this.value = (double)((long)sign * mantissa) * Math.pow(2.0, exponent);
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream os = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(os, false);
        this.code = os.getArray();
    }

    public String toString() {
        return "" + this.value;
    }
}

