/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber.types;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.internal.Util;
import com.beanit.asn1bean.ber.types.BerType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerBitString
implements Serializable,
BerType {
    public static final BerTag tag = new BerTag(0, 0, 3);
    private static final long serialVersionUID = 1L;
    public byte[] value = null;
    public int numBits;
    private byte[] code = null;

    public BerBitString() {
    }

    public BerBitString(byte[] value, int numBits) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits cannot be negative.");
        }
        if (numBits > value.length * 8) {
            throw new IllegalArgumentException("'value' is too short to hold all bits.");
        }
        this.value = value;
        this.numBits = numBits;
    }

    public BerBitString(boolean[] value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.numBits = value.length;
        this.value = new byte[(this.numBits + 7) / 8];
        for (int i = 0; i < this.numBits; ++i) {
            if (!value[i]) continue;
            this.value[i / 8] = (byte)(this.value[i / 8] | 1 << 7 - i % 8);
        }
    }

    public BerBitString(byte[] code) {
        this.code = code;
    }

    public boolean[] getValueAsBooleans() {
        if (this.value == null) {
            return null;
        }
        boolean[] booleans = new boolean[this.numBits];
        for (int i = 0; i < this.numBits; ++i) {
            booleans[i] = (this.value[i / 8] & 1 << 7 - i % 8) > 0;
        }
        return booleans;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        for (int i = this.value.length - 1; i >= 0; --i) {
            reverseOS.write(this.value[i]);
        }
        reverseOS.write(this.value.length * 8 - this.numBits);
        int codeLength = this.value.length + 1;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val - 1];
        int unusedBits = is.read();
        if (unusedBits == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        if (unusedBits > 7) {
            throw new IOException("Number of unused bits in bit string expected to be less than 8 but is: " + unusedBits);
        }
        this.numBits = this.value.length * 8 - unusedBits;
        if (this.value.length > 0) {
            Util.readFully(is, this.value);
        }
        return codeLength += this.value.length + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (boolean bit : this.getValueAsBooleans()) {
            if (bit) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

