/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.compiler.cli;

import com.beanit.asn1bean.compiler.cli.CliParameterBuilder;
import com.beanit.asn1bean.compiler.cli.CliParseException;
import com.beanit.asn1bean.compiler.cli.ValueCliParameter;

public class LongCliParameter
extends ValueCliParameter {
    Long value;
    private Long defaultValue = null;

    LongCliParameter(CliParameterBuilder builder, String parameterName, long defaultValue) {
        super(builder, parameterName);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    LongCliParameter(CliParameterBuilder builder, String parameterName) {
        super(builder, parameterName);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    int parse(String[] args, int i) throws CliParseException {
        this.selected = true;
        if (args.length < i + 2) {
            throw new CliParseException("Parameter " + this.name + " has no value.");
        }
        try {
            this.value = Long.decode(args[i + 1]);
        }
        catch (Exception e) {
            throw new CliParseException("Parameter value " + args[i + 1] + " cannot be converted to long.");
        }
        return 2;
    }

    @Override
    void appendDescription(StringBuilder sb) {
        super.appendDescription(sb);
        if (this.defaultValue != null) {
            sb.append(" Default is ").append(this.defaultValue).append(".");
        }
    }
}

