/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.StringUtils;

class AzureServiceBusJmsPropertiesBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders;

    AzureServiceBusJmsPropertiesBeanPostProcessor(ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders) {
        this.connectionStringProviders = connectionStringProviders;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        AzureServiceBusJmsProperties jmsProperties;
        if (bean instanceof AzureServiceBusJmsProperties && !StringUtils.hasText((String)(jmsProperties = (AzureServiceBusJmsProperties)bean).getConnectionString())) {
            this.connectionStringProviders.ifAvailable(provider -> jmsProperties.setConnectionString(provider.getConnectionString()));
        }
        return bean;
    }
}

