// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import java.io.IOException;
import java.util.List;

/**
 * The list Traffic Manager profiles operation response.
 */
@Fluent
public final class ProfileListResult implements JsonSerializable<ProfileListResult> {
    /*
     * Gets the list of Traffic manager profiles.
     */
    private List<ProfileInner> value;

    /**
     * Creates an instance of ProfileListResult class.
     */
    public ProfileListResult() {
    }

    /**
     * Get the value property: Gets the list of Traffic manager profiles.
     * 
     * @return the value value.
     */
    public List<ProfileInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets the list of Traffic manager profiles.
     * 
     * @param value the value value to set.
     * @return the ProfileListResult object itself.
     */
    public ProfileListResult withValue(List<ProfileInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProfileListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProfileListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProfileListResult.
     */
    public static ProfileListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProfileListResult deserializedProfileListResult = new ProfileListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ProfileInner> value = reader.readArray(reader1 -> ProfileInner.fromJson(reader1));
                    deserializedProfileListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProfileListResult;
        });
    }
}
