// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for TrafficManagerManagementClient class.
 */
public interface TrafficManagerManagementClient {
    /**
     * Gets The ID of the target subscription.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the EndpointsClient object to access its operations.
     * 
     * @return the EndpointsClient object.
     */
    EndpointsClient getEndpoints();

    /**
     * Gets the ProfilesClient object to access its operations.
     * 
     * @return the ProfilesClient object.
     */
    ProfilesClient getProfiles();

    /**
     * Gets the GeographicHierarchiesClient object to access its operations.
     * 
     * @return the GeographicHierarchiesClient object.
     */
    GeographicHierarchiesClient getGeographicHierarchies();

    /**
     * Gets the HeatMapsClient object to access its operations.
     * 
     * @return the HeatMapsClient object.
     */
    HeatMapsClient getHeatMaps();

    /**
     * Gets the TrafficManagerUserMetricsKeysClient object to access its operations.
     * 
     * @return the TrafficManagerUserMetricsKeysClient object.
     */
    TrafficManagerUserMetricsKeysClient getTrafficManagerUserMetricsKeys();
}
