// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Class representing a region in the Geographic hierarchy used with the Geographic traffic routing method.
 */
@Fluent
public final class Region implements JsonSerializable<Region> {
    /*
     * The code of the region
     */
    private String code;

    /*
     * The name of the region
     */
    private String name;

    /*
     * The list of Regions grouped under this Region in the Geographic Hierarchy.
     */
    private List<Region> regions;

    /**
     * Creates an instance of Region class.
     */
    public Region() {
    }

    /**
     * Get the code property: The code of the region.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: The code of the region.
     * 
     * @param code the code value to set.
     * @return the Region object itself.
     */
    public Region withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the name property: The name of the region.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the region.
     * 
     * @param name the name value to set.
     * @return the Region object itself.
     */
    public Region withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the regions property: The list of Regions grouped under this Region in the Geographic Hierarchy.
     * 
     * @return the regions value.
     */
    public List<Region> regions() {
        return this.regions;
    }

    /**
     * Set the regions property: The list of Regions grouped under this Region in the Geographic Hierarchy.
     * 
     * @param regions the regions value to set.
     * @return the Region object itself.
     */
    public Region withRegions(List<Region> regions) {
        this.regions = regions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (regions() != null) {
            regions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("regions", this.regions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Region from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Region if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Region.
     */
    public static Region fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Region deserializedRegion = new Region();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedRegion.code = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRegion.name = reader.getString();
                } else if ("regions".equals(fieldName)) {
                    List<Region> regions = reader.readArray(reader1 -> Region.fromJson(reader1));
                    deserializedRegion.regions = regions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegion;
        });
    }
}
