// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Class which is a sparse representation of a Traffic Manager endpoint.
 */
@Fluent
public final class HeatMapEndpoint implements JsonSerializable<HeatMapEndpoint> {
    /*
     * The ARM Resource ID of this Traffic Manager endpoint.
     */
    private String resourceId;

    /*
     * A number uniquely identifying this endpoint in query experiences.
     */
    private Integer endpointId;

    /**
     * Creates an instance of HeatMapEndpoint class.
     */
    public HeatMapEndpoint() {
    }

    /**
     * Get the resourceId property: The ARM Resource ID of this Traffic Manager endpoint.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The ARM Resource ID of this Traffic Manager endpoint.
     * 
     * @param resourceId the resourceId value to set.
     * @return the HeatMapEndpoint object itself.
     */
    public HeatMapEndpoint withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the endpointId property: A number uniquely identifying this endpoint in query experiences.
     * 
     * @return the endpointId value.
     */
    public Integer endpointId() {
        return this.endpointId;
    }

    /**
     * Set the endpointId property: A number uniquely identifying this endpoint in query experiences.
     * 
     * @param endpointId the endpointId value to set.
     * @return the HeatMapEndpoint object itself.
     */
    public HeatMapEndpoint withEndpointId(Integer endpointId) {
        this.endpointId = endpointId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeNumberField("endpointId", this.endpointId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HeatMapEndpoint from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HeatMapEndpoint if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HeatMapEndpoint.
     */
    public static HeatMapEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HeatMapEndpoint deserializedHeatMapEndpoint = new HeatMapEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedHeatMapEndpoint.resourceId = reader.getString();
                } else if ("endpointId".equals(fieldName)) {
                    deserializedHeatMapEndpoint.endpointId = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHeatMapEndpoint;
        });
    }
}
