// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The status of the Traffic Manager profile.
 */
public final class ProfileStatus extends ExpandableStringEnum<ProfileStatus> {
    /**
     * Static value Enabled for ProfileStatus.
     */
    public static final ProfileStatus ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for ProfileStatus.
     */
    public static final ProfileStatus DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of ProfileStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ProfileStatus() {
    }

    /**
     * Creates or finds a ProfileStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ProfileStatus.
     */
    public static ProfileStatus fromString(String name) {
        return fromString(name, ProfileStatus.class);
    }

    /**
     * Gets known ProfileStatus values.
     * 
     * @return known ProfileStatus values.
     */
    public static Collection<ProfileStatus> values() {
        return values(ProfileStatus.class);
    }
}
