// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.trafficmanager.models.Region;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Class representing the Geographic hierarchy used with the Geographic traffic routing method. */
@Fluent
public final class TrafficManagerGeographicHierarchyInner extends ProxyResource {
    /*
     * The properties of the Geographic Hierarchy resource.
     */
    @JsonProperty(value = "properties")
    private GeographicHierarchyProperties innerProperties;

    /** Creates an instance of TrafficManagerGeographicHierarchyInner class. */
    public TrafficManagerGeographicHierarchyInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Geographic Hierarchy resource.
     *
     * @return the innerProperties value.
     */
    private GeographicHierarchyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the geographicHierarchy property: The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     *
     * @return the geographicHierarchy value.
     */
    public Region geographicHierarchy() {
        return this.innerProperties() == null ? null : this.innerProperties().geographicHierarchy();
    }

    /**
     * Set the geographicHierarchy property: The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     *
     * @param geographicHierarchy the geographicHierarchy value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withGeographicHierarchy(Region geographicHierarchy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GeographicHierarchyProperties();
        }
        this.innerProperties().withGeographicHierarchy(geographicHierarchy);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
