// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.trafficmanager.fluent.models.DeleteOperationResultInner;
import com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.azure.resourcemanager.trafficmanager.models.EndpointTypes;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in EndpointsClient. */
public interface EndpointsClient {
    /**
     * Update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be updated.
     * @param endpointName The name of the Traffic Manager endpoint to be updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<EndpointInner>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters);

    /**
     * Update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be updated.
     * @param endpointName The name of the Traffic Manager endpoint to be updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<EndpointInner> updateAsync(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters);

    /**
     * Update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be updated.
     * @param endpointName The name of the Traffic Manager endpoint to be updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the Update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<EndpointInner> updateWithResponse(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters,
        Context context);

    /**
     * Update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be updated.
     * @param endpointName The name of the Traffic Manager endpoint to be updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    EndpointInner update(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters);

    /**
     * Gets a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint.
     * @param endpointName The name of the Traffic Manager endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager endpoint along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<EndpointInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName);

    /**
     * Gets a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint.
     * @param endpointName The name of the Traffic Manager endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager endpoint on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<EndpointInner> getAsync(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName);

    /**
     * Gets a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint.
     * @param endpointName The name of the Traffic Manager endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager endpoint along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<EndpointInner> getWithResponse(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName, Context context);

    /**
     * Gets a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint.
     * @param endpointName The name of the Traffic Manager endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    EndpointInner get(String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName);

    /**
     * Create or update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be created or updated.
     * @param endpointName The name of the Traffic Manager endpoint to be created or updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<EndpointInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters);

    /**
     * Create or update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be created or updated.
     * @param endpointName The name of the Traffic Manager endpoint to be created or updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<EndpointInner> createOrUpdateAsync(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters);

    /**
     * Create or update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be created or updated.
     * @param endpointName The name of the Traffic Manager endpoint to be created or updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the CreateOrUpdate operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<EndpointInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters,
        Context context);

    /**
     * Create or update a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be created or updated.
     * @param endpointName The name of the Traffic Manager endpoint to be created or updated.
     * @param parameters The Traffic Manager endpoint parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    EndpointInner createOrUpdate(
        String resourceGroupName,
        String profileName,
        EndpointTypes endpointType,
        String endpointName,
        EndpointInner parameters);

    /**
     * Deletes a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be deleted.
     * @param endpointName The name of the Traffic Manager endpoint to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeleteOperationResultInner>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName);

    /**
     * Deletes a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be deleted.
     * @param endpointName The name of the Traffic Manager endpoint to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeleteOperationResultInner> deleteAsync(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName);

    /**
     * Deletes a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be deleted.
     * @param endpointName The name of the Traffic Manager endpoint to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeleteOperationResultInner> deleteWithResponse(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName, Context context);

    /**
     * Deletes a Traffic Manager endpoint.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param profileName The name of the Traffic Manager profile.
     * @param endpointType The type of the Traffic Manager endpoint to be deleted.
     * @param endpointName The name of the Traffic Manager endpoint to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeleteOperationResultInner delete(
        String resourceGroupName, String profileName, EndpointTypes endpointType, String endpointName);
}
