// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.trafficmanager.models.HeatMapEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficFlow;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Class representing a Traffic Manager HeatMap properties. */
@Fluent
public final class HeatMapProperties {
    /*
     * The beginning of the time window for this HeatMap, inclusive.
     */
    @JsonProperty(value = "startTime")
    private OffsetDateTime startTime;

    /*
     * The ending of the time window for this HeatMap, exclusive.
     */
    @JsonProperty(value = "endTime")
    private OffsetDateTime endTime;

    /*
     * The endpoints used in this HeatMap calculation.
     */
    @JsonProperty(value = "endpoints")
    private List<HeatMapEndpoint> endpoints;

    /*
     * The traffic flows produced in this HeatMap calculation.
     */
    @JsonProperty(value = "trafficFlows")
    private List<TrafficFlow> trafficFlows;

    /** Creates an instance of HeatMapProperties class. */
    public HeatMapProperties() {
    }

    /**
     * Get the startTime property: The beginning of the time window for this HeatMap, inclusive.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The beginning of the time window for this HeatMap, inclusive.
     *
     * @param startTime the startTime value to set.
     * @return the HeatMapProperties object itself.
     */
    public HeatMapProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The ending of the time window for this HeatMap, exclusive.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The ending of the time window for this HeatMap, exclusive.
     *
     * @param endTime the endTime value to set.
     * @return the HeatMapProperties object itself.
     */
    public HeatMapProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the endpoints property: The endpoints used in this HeatMap calculation.
     *
     * @return the endpoints value.
     */
    public List<HeatMapEndpoint> endpoints() {
        return this.endpoints;
    }

    /**
     * Set the endpoints property: The endpoints used in this HeatMap calculation.
     *
     * @param endpoints the endpoints value to set.
     * @return the HeatMapProperties object itself.
     */
    public HeatMapProperties withEndpoints(List<HeatMapEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get the trafficFlows property: The traffic flows produced in this HeatMap calculation.
     *
     * @return the trafficFlows value.
     */
    public List<TrafficFlow> trafficFlows() {
        return this.trafficFlows;
    }

    /**
     * Set the trafficFlows property: The traffic flows produced in this HeatMap calculation.
     *
     * @param trafficFlows the trafficFlows value to set.
     * @return the HeatMapProperties object itself.
     */
    public HeatMapProperties withTrafficFlows(List<TrafficFlow> trafficFlows) {
        this.trafficFlows = trafficFlows;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpoints() != null) {
            endpoints().forEach(e -> e.validate());
        }
        if (trafficFlows() != null) {
            trafficFlows().forEach(e -> e.validate());
        }
    }
}
