// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Min and max value of a status code range. */
@Fluent
public final class MonitorConfigExpectedStatusCodeRangesItem {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MonitorConfigExpectedStatusCodeRangesItem.class);

    /*
     * Min status code.
     */
    @JsonProperty(value = "min")
    private Integer min;

    /*
     * Max status code.
     */
    @JsonProperty(value = "max")
    private Integer max;

    /**
     * Get the min property: Min status code.
     *
     * @return the min value.
     */
    public Integer min() {
        return this.min;
    }

    /**
     * Set the min property: Min status code.
     *
     * @param min the min value to set.
     * @return the MonitorConfigExpectedStatusCodeRangesItem object itself.
     */
    public MonitorConfigExpectedStatusCodeRangesItem withMin(Integer min) {
        this.min = min;
        return this;
    }

    /**
     * Get the max property: Max status code.
     *
     * @return the max value.
     */
    public Integer max() {
        return this.max;
    }

    /**
     * Set the max property: Max status code.
     *
     * @param max the max value to set.
     * @return the MonitorConfigExpectedStatusCodeRangesItem object itself.
     */
    public MonitorConfigExpectedStatusCodeRangesItem withMax(Integer max) {
        this.max = max;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
